<?php

// ================ Functions ===============


function randomNum($len)
{
    $str_result = '0123456789';
    return substr(str_shuffle($str_result), 0, $len);
}

function random($len)
{
    $str_result = '0123456789abcefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    return substr(str_shuffle($str_result), 0, $len);
}


function generateUniqueId($VARS) {
    $unique = uniqid($VARS, true); // More entropy
    $hash = substr(md5($unique), 0, 10); // First 10 chars of MD5 hash
    $random = substr(bin2hex(random_bytes(6)), 0, 12); // 12 random hex chars

    return strtoupper($hash . $random); // Ensure uppercase for consistency
}


function isValidIndianMobile($number) {
    // Check if the number is exactly 10 digits long and starts with 7, 8, or 9
    return preg_match('/^[6789]\d{9}$/', $number);
}

function isValidIndianEmail($email) {
    if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
        return true;
    }else{
         return false;
    }
    
}



function timeAgo($datetime, $full = false)
{
$now = new DateTime;
$ago = new DateTime($datetime);
$diff = get_object_vars($now->diff($ago));
$diff['w'] = floor($diff['d'] / 7);
$diff['d'] -= $diff['w'] * 7;

    $string = array(
        'y' => 'year',
        'm' => 'month',
        'w' => 'weak',
        'd' => 'day',
        'h' => 'hour',
        'i' => 'min.',
        's' => 'sec.',
    );
    foreach ($string as $k => &$v) {
        
        if ($diff[$k]) {
            
            if($k == 'm') {
              $v = $diff[$k] . ' ' . $v . ($diff[$k] > 1 ? '' : '');
            } else {
              $v = $diff[$k] . ' ' . $v . ($diff[$k] > 1 ? '' : '');
            }
            
        } else {
            unset($string[$k]);
        }
    }

    if (!$full) $string = array_slice($string, 0, 1);
    return $string ? implode(', ', $string) . ' ago' : 'just now';
}


function counter($num)
{
    if ($num > 1000) {

        $x = round($num);
        $x_number_format = number_format($x);
        $x_array = explode(',', $x_number_format);
        $x_parts = array('k+', 'm+', 'b+', 't+');
        $x_count_parts = count($x_array) - 1;
        $x_display = $x;
        $x_display = $x_array[0] . ((int) $x_array[1][0] !== 0 ? '.' . $x_array[1][0] : '');
        $x_display .= $x_parts[$x_count_parts - 1];

        return $x_display;
    }

    return $num;
}
