<?php


date_default_timezone_set('Asia/Kolkata');

require_once("../includes/db.php");

require_once("helper.php");
require_once("account.php");
require_once("other.php");
require_once("prompts.php");
require_once("tools.php");


function returnError($CODE)
{
    // -- Return with error while someone trying to hack---
    echo "Oops...! 404 not found Error Code : " . $CODE;
    exit();
}


function checkKey($key)
{
    return $key == AUTH_KEY;
}


// ================ Security Checkup ===============

if (isset($_GET['type'],$_POST['key'])) {

    $type = mysqli_real_escape_string(getConn(), $_GET['type']);
    $key =  mysqli_real_escape_string(getConn(), $_POST['key']);

    // --- Allow only text no any special character to prevent sql injection and attacks --------
    $verify =   !(preg_match('/[^a-zA-Z_]/', $type));

    if ($verify && checkKey($key)) {

        getData($type);
    } else {
        returnError("1");
    }
}


function getData($type = "")
{

    // ------ Get Data ----

    if ($type == "flash") {
        getFlash();
    } else if ($type == "login") {
        login();
    } else if ($type == "contact") {
        contact();
    } else if ($type == "report") {
        report();
    } else if ($type == "view_count") {
        viewCount();
    }
    // -------- Prompts ----
    else if ($type == "category") {
        getCategory();
    }else if ($type == "category_view") {
        getCategoryView();
    }else if ($type == "prompts") {
        getPrompts();
    }else if ($type == "saved") {
        getSaved();
    }else if ($type == "search") {
        getSearch();
    }else if ($type == "tools") {
        getTools();
    }else if ($type == "notifications") {
        getNotify();
    }

    else {
        returnError("3");
    }
}


// ======================= Functions ===============


function sendOtpOnEmail($email, $OTP) {
    



}


function query($query)
{
    $data['res'] = array();

    $fire_query = mysqli_query(getConn(), $query);

    while ($item = mysqli_fetch_assoc($fire_query)) {

        array_push($data['res'], $item);
    }

    return $data['res'];
}


