<?php

require_once("app.php");

$_SESSION['profile_url'] = $_SERVER['REQUEST_URI'];

if (!isset($_GET['id'])) {
    exit();
}

$edit = false;
if (isset($_GET['edit'])) {
    $edit = mysqli_real_escape_string(getConn(), $_GET['edit']);
}

$uid = mysqli_real_escape_string(getConn(), $_GET['id']);



if (isset($_POST['update'])) {


    $user_id = mysqli_real_escape_string(getConn(), $_POST['id']);
    $user_name = mysqli_real_escape_string(getConn(), $_POST['name']);
    $user_email = mysqli_real_escape_string(getConn(), $_POST['email']);
    $user_mobile = mysqli_real_escape_string(getConn(), $_POST['mobile']);
    $modified_date = mysqli_real_escape_string(getConn(), $_POST['modified_date']);

    $user_status = mysqli_real_escape_string(getConn(), $_POST['status']);

    $modified_date = date("Y-m-d H:i:s");


    $query = "UPDATE `users` SET 
    `name`='$user_name',`email`='$user_email',`mobile`='$user_mobile',`profile`='$user_profile',
    `modified_date`='$modified_date',`status`='$user_status'
    
    WHERE id = $user_id LIMIT 1";

    if (mysqli_query(getConn(), $query)) {

        echo "<script>history.go(-1)</script>";
    } else {
        echo "<script>alert('Failed to update')</script>";
    }
} else if (isset($_POST['change_password'])) {

    $user_id = mysqli_real_escape_string(getConn(), $_POST['id']);

    $new_password = md5(mysqli_real_escape_string(getConn(), $_POST['new_password']));
    $modified_date = date("Y-m-d H:i:s");

    $query = "UPDATE `users` SET
    `password`='$new_password',
    `modified_date`='$modified_date'
    WHERE id = $user_id LIMIT 1";

    if (mysqli_query(getConn(), $query)) {
        echo "<script>history.go(-1)</script>";
    } else {
        echo "<script>alert('Failed to update')</script>";
    }
}


$user = mysqli_fetch_assoc(mysqli_query(getConn(), "SELECT * FROM `users` WHERE id = $uid LIMIT 1"));


$TAB = "orders";

if (isset($_GET['tab'])) {
    $TAB = $_GET['tab'];
}


?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php getHead("User Details"); ?>
</head>

<style>
    .profile {
        margin: 100px 20px;
        border-radius: 20px;
        padding: 20px;
        text-align: center;
        background-color: white;
        border: 1px solid var(--color-border);
    }

    .profile .img img {
        height: 160px;
        width: 160px;
        display: block;
        margin: -100px auto 0 auto;
        border-radius: 50%;
        background-color: white;
        border: 5px solid var(--color-primary);
        box-shadow: 0px 0px 3px 3px rgba(0, 0, 0, 0.05);
        object-fit: cover;
    }

    .profile .bold {
        font-weight: bolder;
        color: #000;
        font-size: 18px;
    }

    .profile .text {
        font-size: 14px;
        color: #4a4a4a;
        margin-top: 10px;
    }


    .profile .name {
        font-size: 25px;
        margin: 10px;
    }

    .profile .email {
        color: #4a4a4a;
    }

    .profile .details {
        margin: 50px 20px;
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        grid-auto-rows: 100px;
        grid-gap: 20px;
    }


    .action {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        grid-auto-rows: 40px;
        grid-gap: 20px;

    }

    .action a {
        background-color: var(--color-primary);
        color: white;
        border-radius: 10px;
        line-height: 40px;
        padding: 0 20px;
        box-sizing: border-box;
        cursor: pointer;
    }

    .action input,
    .action i {
        margin-right: 20px;
    }

    .action i {
        color: white;
    }

    .action input {
        cursor: pointer;
        accent-color: #004fe3;
        color: white;
        height: 15px;
        width: 15px;
    }

    .green {
        font-weight: bolder;
        color: green;
    }

    .red {
        font-weight: bolder;
        color: tomato;
    }


    /* ============================================================ Addresess ===================== */


    .addresses {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(400px, 1fr));
        grid-gap: 15px;
        margin: 10px;
        background-color: white;
        padding: 15px;
    }

    .addresses .address {
        width: 100%;
        height: 100%;
        min-height: 100px;
        border: 1px solid var(--color-border);
        border-radius: 15px;
        padding: 15px;
        position: relative;
        overflow: hidden;
        cursor: pointer;
        display: flex;
        flex-direction: column;
        gap: 10px;
        background-color: white;
    }

    .addresses .address .name {
        font-size: 16px;
        font-weight: 500;
    }

    .addresses .address .full_address {
        font-size: 14px;
        color: var(--color-lite-text);
    }

    .addresses .address .mobile {
        font-size: 14px;
        color: var(--color-lite-text);
    }

    @media screen and (max-width : 600px) {
        .addresses {
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
        }

    }




    /*============ TABS =========*/
    .tabs {
        display: flex;
        border-bottom: 1px solid #ddd;
        margin-bottom: 20px;
        font-family: Arial, sans-serif;
    }

    .tabs a {
        padding: 12px 20px;
        text-decoration: none;
        color: #555;
        font-weight: 500;
        font-size: 14px;
        border: 1px solid transparent;
        border-bottom: none;
        margin-right: 5px;
        border-radius: 4px 4px 0 0;
        transition: all 0.3s ease;
        background-color: #f8f9fa;
    }

    .tabs a:hover {
        background-color: #e9ecef;
        color: #333;
    }

    .tabs a.active {
        background-color: #fff;
        color: #007bff;
        border-color: #ddd;
        border-bottom-color: #fff;
        position: relative;
    }

    .tabs a.active:after {
        content: '';
        position: absolute;
        bottom: -1px;
        left: 0;
        right: 0;
        height: 2px;
        background-color: #007bff;
    }

    .action a {
        color: white !important;
    }
</style>


<body>
    <?php require_once("includes/header.php"); ?>

    <!-- =======================User Details================ -->

    <div class="profile">

        <div class="img">

            <img src="<?php echo strlen($user['profile']) > 10 ? getImage($user['profile']) : "img/user.png" ?>" alt="">

        </div>

        <div class="name bold"><?php echo $user['name'] ?></div>
        <div class="email">Email : <?php echo $user['email'] ?></div>
        <div class="mobile">Mobile : <?php echo $user['mobile'] ?></div>


        <div class="details">

            <div>
                <div class="bold"><?php echo date("d/m/Y H:i:s", strtotime($user['date'])); ?></div>
                <div class="text">Created On</div>
            </div>

            <div>
                <div class="bold"><?php echo date("d/m/Y H:i:s", strtotime($user['modified_date'])); ?></div>
                <div class="text">Last Modify</div>
            </div>


            <div>
                <div class="bold"><?php echo timeAgo($user['last_seen']); ?></div>
                <div class="text">Last Seen</div>
            </div>

        </div>


        <div class="action">

            <a href="notification_send.php?uid=<?php echo $user['id'] ?>"><i class="bx bx-bell"></i>
                Send Notification
            </a>

            <a href="#" data-bs-toggle="modal" data-bs-target="#changePasswordModal">
                <i class="bx bx-lock"></i> Change Password
            </a>

            <?php
            if ($edit == "true") { ?>
                <a href="<?php echo ADMIN_BASE; ?>users_profile.php?id=<?php echo $uid; ?>&edit=false"><i class="bx bx-show"></i>
                    View Mode
                </a>
            <?php } else { ?>
                <a href="<?php echo ADMIN_BASE; ?>users_profile.php?id=<?php echo $uid; ?>&edit=true"><i class="bx bx-edit"></i>
                    Edit Mode
                </a>
            <?php }
            ?>

        </div>


    </div>

    <!-- ===================================== Password Modal ====================== -->
    <div class="modal fade" id="changePasswordModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="passwordChangeForm" method="POST" action="">
                    <input type="hidden" name="id" value="<?php echo $user['id']; ?>">
                    <input type="hidden" name="change_password" value="<?php echo $user['id']; ?>">
                    <div class="modal-header">
                        <h5 class="modal-title">Set New Password</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="newPassword" class="form-label">New Password</label>
                            <input type="password" class="form-control" name="new_password" id="newPassword" required
                                placeholder="Enter your new password" minlength="6">
                            <div class="form-text">Minimum 6 characters</div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Save Password</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        document.getElementById('passwordChangeForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const form = this;
            const newPassword = document.getElementById('newPassword').value;

            if (!newPassword) {
                alert('Please enter a new password');
                return;
            }

            if (newPassword.length < 6) {
                alert('Password must be at least 6 characters');
                return;
            }
            form.submit();
        });
    </script>




    <?php if ($edit == "true") {
        getEditForm();
    } ?>

    <!-- ================EXTRA JS===================== -->


    <?php require_once("includes/footer.php");

    function getEditForm()
    {
        global $user;

    ?>
        <form action="" method="POST">

            <input type="hidden" name="id" value="<?php echo $_GET['id'] ?>">

            <label for="name">Name : </label>
            <input type="text" id="name" name="name" placeholder="Name here.." value="<?php echo $user['name']; ?>">



            <label for="email">Email : </label>
            <input type="text" id="email" name="email" placeholder="Email here.." value="<?php echo $user['email']; ?>">


            <label for="mobile">Mobile : </label>
            <input type="text" id="mobile" name="mobile" placeholder="mobile here.." value="<?php echo $user['mobile']; ?>">


            <label for="profile">Profile url : </label>
            <input type="text" id="profile" name="profile" placeholder="profile url here.." value="<?php echo $user['profile']; ?>">

            <label for="modified_date">Last Update : </label>
            <input type="text" id="modified_date" name="modified_date" placeholder="modified_date here.." value="<?php echo $user['modified_date']; ?>">


            <label for="status">Account Status : </label>
            <select name="status" id="status" required>
                <option value="0" <?php echo $user['status'] == "0" ? "selected" : ""; ?>>Block</option>
                <option value="1" <?php echo $user['status'] == "1" ? "selected" : ""; ?>>USER</option>
                <option value="2" <?php echo $user['status'] == "2" ? "selected" : ""; ?>>Unverified</option>
            </select>


            <br><br>

            <input type="submit" value="Update Details" name="update">

        </form>
    <?php
    }
