<?php

require_once("app.php");

if (isset($_GET['page'])) {
    $page = mysqli_real_escape_string(getConn(), $_GET['page']);
    if ($page <= 0) {
        $page = 1;
    }
} else {
    $page = 1;
}

$per_page = 30;

$start = ($page - 1) * $per_page;


$by_users_status = " status = 1";


$search_query = "";


$order_url = "";
$order_type = "latest";
$order_by = "ORDER BY id DESC";


if (isset($_GET['order'])) {

    $order_type = mysqli_real_escape_string(getConn(), $_GET['order']);

    $order_url = "order=" . $order_type . "&";

    if ($order_type === "latest") {

        $order_by = "ORDER BY id DESC";
    } else if ($order_type === "block_latest") {

        $order_by = "ORDER BY id DESC";
        $by_users_status = " status = 0";
    } else if ($order_type === "block_old") {

        $order_by = "ORDER BY id ASC";
        $by_users_status = " status = 0";
    } else if ($order_type === "verify_latest") {

        $order_by = "ORDER BY id DESC";
        $by_users_status = " status = 4";
    } else if ($order_type === "verify_old") {

        $order_by = "ORDER BY id ASC";
        $by_users_status = " status = 4";
    } else {

        $order_by = "ORDER BY id ASC";
    }
}



$totalUsers = mysqli_num_rows(mysqli_query(getConn(), "SELECT `id` FROM `users` WHERE $by_users_status $order_by"));

if (isset($_GET['q'])) {

    $search = mysqli_real_escape_string(getConn(), $_GET['q']);

    $search_query = "q=$search&";

    $quser;
    if (is_numeric($search)) {
        $quser = "SELECT * FROM `users` 
        WHERE id = $search && $by_users_status $order_by LIMIT 10";
    } else {
        $quser = "SELECT * FROM `users` 
        WHERE lower(email) LIKE lower('%$search%') || lower(name) LIKE lower('%$search%') && $by_users_status $order_by LIMIT $start,$per_page";
    }

    $users = mysqli_query(getConn(), $quser);

    $totalUsers = mysqli_num_rows(mysqli_query(getConn(), "SELECT * FROM `users` 
    WHERE lower(email) LIKE lower('%$search%') || lower(name) LIKE lower('%$search%') && $by_users_status $order_by"));
} else {

    $search = "Search Here...";
    $users = mysqli_query(getConn(), "SELECT * FROM `users` WHERE $by_users_status $order_by limit $start,$per_page");
}


// =====Pagination====
$totalPage = ceil($totalUsers / $per_page);

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php getHead("Users"); ?>
</head>

<style>
    .profile img {
        transition: all 0.5s;
        background: white;
        cursor: pointer;
    }

    .profile img:hover {
        transform: scale(1.01);
    }
</style>

<body>
    <?php require_once("includes/header.php"); ?>


    <!-- =======================User LIST================ -->

    <main>
        <div class="table_header">
            <div>
                <form action="" method="get" id="search_f">
                    <input type="hidden" name="order" value="<?php echo $order_type ?>">

                    <input type="search" name="q" id="search" placeholder="<?php echo $search ?>">
                    <input type="submit" value="Search">
                </form>
            </div>

            <a href="users_add.php?type=1">Add User</a>

            <div class="select">

                <select name="order" id="order" onchange="changeOrder(this.value)">

                    <optgroup label="All">
                        <option value="latest" <?php echo $order_type == "latest" ? "selected" : ""; ?>>Latest Users</option>
                        <option value="old" <?php echo $order_type == "old" ? "selected" : ""; ?>>Old Users</option>
                    </optgroup>

                    <optgroup label="Block">
                        <option value="block_old" <?php echo $order_type == "block_old" ? "block_old" : ""; ?>>Old Users</option>
                        <option value="block_latest" <?php echo $order_type == "block_latest" ? "selected" : ""; ?>>Latest Users</option>
                    </optgroup>

                    <optgroup label="Unverify">
                        <option value="verify_old" <?php echo $order_type == "verify_old" ? "selected" : ""; ?>>Old</option>
                        <option value="verify_latest" <?php echo $order_type == "verify_latest" ? "selected" : ""; ?>>Latest</option>
                    </optgroup>

                </select>
            </div>
            <script>
                function changeOrder(val) {
                    let orderElement = document.createElement("a");
                    orderElement.setAttribute("href", "?order=" + val);
                    orderElement.click();
                }
            </script>
        </div>


        <table class="caption-top">

            <caption>Users</caption>


            <tr>
                <th>UID</th>
                <th>Pofile</th>
                <th>Name</th>
                <th>Email</th>
                <th>Mobile</th>
                <th>Actions</th>
            </tr>

            <?php

            while ($r = mysqli_fetch_assoc($users)) {

                $id = $r['id'];
                $name = $r['name'];
                $email = $r['email'];
                $mobile = $r['mobile'];
                $profile = $r['profile'];
                $status = $r['status'];
            ?>
                <tr>
                    <td><?php echo $id ?></td>

                    <td class="profile"><img src="<?php echo strlen($profile) > 10 ? getImage($profile) : "img/user.png"; ?>" loading="lazy"></td>

                    <td class="fill"><?php echo $name ?></td>
                    <td><?php echo $email ?></td>
                    <td><?php echo $mobile ?></td>

                    <td class="actions">
                        <input type="checkbox" <?php echo $status > 0 ? "checked" : ""; ?> onclick="changeStatus('<?php echo $id ?>',this,'users')" id="status" title="Block user">
                        <a href="users_profile.php?id=<?php echo $id ?>&edit=true" class="dodgerblue" title="Edit User"><i class="bx bx-edit"></i></a>
                        <a href="users_profile.php?id=<?php echo $id ?>&edit=false" class="blue" title="View Profile"><i class='bx bx-show-alt'></i></a>

                        <?php if ($status == 0) { ?>
                            <a onclick="deleteItem('<?php echo $id ?>','delete_users')" class="red" title="Delete User Permanently"><i class="bx bx-trash"></i></a>

                        <?php  } ?>


                    </td>
                </tr>

            <?php
            }
            ?>
        </table>

        <!-- ===============Pagination=============== -->

        <?php generatePagination($page, $totalPage, "?" . $order_url . $search_query); ?>

    </main>

    <?php require_once("includes/footer.php"); ?>