<?php

require_once('app.php');

if (isset($_GET['page'])) {
    $page = $_GET['page'];
    if ($page <= 0) {
        $page = 1;
    }
} else {
    $page = 1;
}

$per_page = 30;

$start = ($page - 1) * $per_page;

$search_query = "";

$order_url = "";
$order_type = "latest";
$order_by = "ORDER BY id DESC";

$by_item_status = "status > 0";


if (isset($_GET['order'])) {

    $order_type = $_GET['order'];

    $order_url = "order=" . $order_type . "&";

    if ($order_type === "unverified") {

        $by_item_status = "status = 0";
    } else if ($order_type === "verified") {

        $by_item_status = "status = 1";
    } else if ($order_type == "all") {

        $by_item_status = "status >= 0";
    } else if ($order_type === "old") {

        $order_by = "ORDER BY id ASC";
    } else {
        $order_by = "ORDER BY id DESC";
    }
}

$totalItems = mysqli_num_rows(mysqli_query($conn, "SELECT `id` FROM tools WHERE $by_item_status $order_by"));

if (isset($_GET['q'])) {

    $search = $_GET['q'];

    $search_query = "q=$search&";

    $qItem;
    if (is_numeric($search)) {
        $qItem = "SELECT * FROM `tools` 
        WHERE id = $search && $by_item_status $order_by LIMIT 10";
    } else {
        $qItem = "SELECT * FROM tools 
        WHERE lower(title) LIKE lower('%$search%') && $by_item_status $order_by LIMIT $start,$per_page";
    }

    $items = mysqli_query($conn, $qItem);

    $totalItems = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM tools 
    WHERE lower(title) LIKE lower('%$search%') && $by_item_status $order_by"));
} else {

    $search = "Search Here...";
    $items = mysqli_query($conn, "SELECT * FROM tools WHERE $by_item_status $order_by limit $start,$per_page");
}


// =====Pagination====
$totalPage = ceil($totalItems / $per_page);

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <?php getHead("Tools"); ?>
</head>

<style>

</style>

<body>
    <?php include_once('includes/header.php'); ?>


    <div class="table_header">
        <div>
            <form action="" method="get" id="search_f">
                <input type="hidden" name="order" value="<?php echo $order_type ?>">

                <input type="search" name="q" id="search" placeholder="<?php echo $search ?>">
                <input type="submit" value="Search">
            </form>
        </div>

        <a href="tools_action.php">Add More</a>

        <select name="order" id="order" onchange="changeOrder(this.value)">
            <option value="all" <?php echo $order_type == "all" ? "selected" : ""; ?>>All</option>
            <option value="unverified" <?php echo $order_type == "unverified" ? "selected" : ""; ?>>Disabled</option>
            <option value="verified" <?php echo $order_type == "verified" ? "selected" : ""; ?>>Enabled</option>
            <option value="latest" <?php echo $order_type == "latest" ? "selected" : ""; ?>>Latest</option>

        </select>

        <script>
            function changeOrder(val) {
                let orderElement = document.createElement("a");
                orderElement.setAttribute("href", "?order=" + val);
                orderElement.click();
            }
        </script>

    </div>


    <table class="caption-top">
        <caption>Wallpapers</caption>

        <tr>
            <th>ID</th>
            <th>Cover</th>
            <th>Title</th>
            <th>Category</th>
            <th>Actions</th>
        </tr>

        <?php

        while ($r = mysqli_fetch_assoc($items)) {

            $id = $r['id'];
            $title = $r['title'];
            $cover = $r['cover'];
            $url = $r['url'];
            $category = $r['category'];
            $status = $r['status'];
        ?>
            <tr>
                <td><?php echo $id ?></td>
                <td><img src="<?php echo getImage($cover); ?>" loading="lazy" id="cover"></td>
                <td><a href="<?php echo $url; ?>" target="_blank"><?php echo $title; ?></a></td>
                <td><?php echo $category ?></td>

                <td class="actions">

                    <input type="checkbox" <?php echo $status == "1" ? "checked" : ""; ?> onclick="changeStatus('<?php echo $id ?>',this,'tools')" id="status" title="Enable/Disable">
                    <a href="tools_action.php?id=<?php echo $id ?>" class="dodgerblue"><i class="bx bx-edit"></i></a>
                    <?php if ($status == "0") {
                    ?>
                        <a onclick="deleteItem('<?php echo $id ?>','delete_tools')" class="red" title="Delete Permanently"><i class="bx bx-trash"></i></a>
                    <?php } ?>
                </td>
            </tr>

        <?php
        }

        ?>

    </table>

    <!-- ===============Pagination=============== -->


    <?php generatePagination($page, $totalPage, "?" . $order_url . $search_query); ?>

    <!-- ===========================EXTRA SCRIPT============= -->

    <?php include_once('includes/footer.php'); ?>