<?php
require_once('app.php');

$def_settings = mysqli_fetch_assoc(mysqli_query(getConn(), "SELECT * FROM `settings` WHERE id = 1 LIMIT 1"));


if (isset($_POST['update'])) {
    $app_name = mysqli_real_escape_string(getConn(), $_POST['app_name']);
    $fcm_project_id = mysqli_real_escape_string(getConn(), $_POST['fcm_project_id']);
    $privacy_policy = mysqli_real_escape_string(getConn(), $_POST['privacy_policy']);
    $terms = mysqli_real_escape_string(getConn(), $_POST['terms']);
    $share = mysqli_real_escape_string(getConn(), $_POST['share']);
    $developer = mysqli_real_escape_string(getConn(), $_POST['developer']);
    $developer_contact = mysqli_real_escape_string(getConn(), $_POST['developer_contact']);
    $about = mysqli_real_escape_string(getConn(), $_POST['about']);
    $prevent_screenshot = mysqli_real_escape_string(getConn(), $_POST['prevent_screenshot']);

    // Handle file upload if provided
    if (!empty($_FILES['config']['name'])) {
        $path = "../google/";
        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }

        $source_file = $_FILES['config']['tmp_name'];
        $file_name = "config" . getExtension($_FILES['config']['name']);
        $destination = $path . $file_name;
        move_uploaded_file($source_file, $destination);
    }

    $q = mysqli_query(getConn(), "
    UPDATE `settings` SET
        `app_name`='$app_name',
        `fcm_project_id`='$fcm_project_id',
        `privacy_policy`='$privacy_policy',
        `terms`='$terms',
        `share`='$share',
        `developer`='$developer',
        `developer_contact`='$developer_contact',
        `about`='$about',
        `prevent_screenshot`='$prevent_screenshot',
        `modified_date`=NOW()
    WHERE id = 1
    LIMIT 1
");

    if ($q) {
        echo "<script>history.go(-1);</script>";
    } else {
        echo "<script>showAlert('Sorry','Something went wrong..')</script>";
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php getHead("Settings"); ?>
    <style>
        fieldset {
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
            background: #f9f9f9;
        }
        
        legend {
            font-weight: bold;
            font-size: 1.2em;
            color: #333;
            padding: 0 10px;
        }
        
        .input {
            margin-bottom: 15px;
        }
        
        .input label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
            color: #555;
        }
        
        .input input[type="text"],
        .input input[type="url"],
        .input textarea,
        .input select {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
            box-sizing: border-box;
        }
        
        .input textarea {
            resize: vertical;
            min-height: 100px;
        }
        
        .input.img {
            background: #fff;
            padding: 15px;
            border-radius: 4px;
            border: 1px dashed #ddd;
        }
        
        #submit_button {
            background: #007bff;
            color: white;
            padding: 12px 30px;
            border: none;
            border-radius: 4px;
            font-size: 16px;
            cursor: pointer;
            display: block;
            margin: 20px auto;
            width: 200px;
        }
        
        #submit_button:hover {
            background: #0056b3;
        }
        
        .file-status {
            margin-top: 5px;
            font-size: 0.9em;
            color: #28a745;
            font-weight: 500;
        }
        
        .file-status.not-available {
            color: #dc3545;
        }
    </style>
</head>

<body>
    <?php include_once('includes/header.php'); ?>

    <form action="" method="POST" enctype="multipart/form-data">
        <fieldset>
            <legend>Firebase Configuration</legend>
            <div class="input img">
                <label>Firebase Config File: </label>
                <div class="inputs">
                    <input type="file" name="config" accept="application/json" />
                </div>
                <div class="file-status <?php echo file_exists('../google/config.json') ? '' : 'not-available'; ?>">
                    <?php
                    $checkConfig = "../google/config.json";
                    if (file_exists($checkConfig)) {
                        echo "✓ Config file available";
                    } else {
                        echo "✗ Config file not available";
                    }
                    ?>
                </div>
            </div>

            <div class="input">
                <label>Firebase Project ID: </label>
                <input type="text" name="fcm_project_id" required value="<?php echo $def_settings['fcm_project_id']; ?>">
            </div>
        </fieldset>

        <fieldset>
            <legend>App Information</legend>
            <div class="input">
                <label>App Name: </label>
                <input type="text" name="app_name" required value="<?php echo $def_settings['app_name']; ?>">
            </div>

            <div class="input">
                <label>Privacy Policy URL: </label>
                <input type="url" name="privacy_policy" required value="<?php echo $def_settings['privacy_policy']; ?>">
            </div>

            <div class="input">
                <label>Terms & Conditions URL: </label>
                <input type="url" name="terms" required value="<?php echo $def_settings['terms']; ?>">
            </div>

            <div class="input">
                <label>About URL: </label>
                <input type="url" name="about" required value="<?php echo $def_settings['about']; ?>">
            </div>
        </fieldset>

        <fieldset>
            <legend>App Features</legend>
            <div class="input">
                <label>Share Text: </label>
                <textarea name="share" rows="4" placeholder="Text that will be shared when users share the app"><?php echo $def_settings['share']; ?></textarea>
            </div>

            <div class="input">
                <label>Prevent Screenshot: </label>
                <select name="prevent_screenshot" required>
                    <option value="0" <?php echo $def_settings['prevent_screenshot'] == '0' ? 'selected' : ''; ?>>Off</option>
                    <option value="1" <?php echo $def_settings['prevent_screenshot'] == '1' ? 'selected' : ''; ?>>On</option>
                </select>
            </div>
        </fieldset>

        <fieldset>
            <legend>Developer Information</legend>
            <div class="input">
                <label>Developer Name: </label>
                <input type="text" name="developer" value="<?php echo $def_settings['developer']; ?>">
            </div>

            <div class="input">
                <label>Developer Contact: </label>
                <input type="text" name="developer_contact" value="<?php echo $def_settings['developer_contact']; ?>">
            </div>
        </fieldset>

        <input type="submit" value="Update Settings" name="update" id="submit_button">
    </form>

    <?php include_once('includes/footer.php'); ?>
</body>
</html>