<?php require_once("app.php");

if (isset($_GET['page'])) {
    $page = mysqli_real_escape_string(getConn(), $_GET['page']);
    if ($page <= 0) {
        $page = 1;
    }
} else {
    $page = 1;
}

$per_page = 30;
$start = ($page - 1) * $per_page;

$search_query = "";
$order_url = "";
$order_type = "pending";
$order_by = "ORDER BY id DESC";
$by_item_status = " status = 0";  // Changed to 0 for pending

if (isset($_GET['order'])) {
    $order_type = mysqli_real_escape_string(getConn(), $_GET['order']);
    $order_url = "order=" . $order_type . "&";

    // ------ Sort --------
    if ($order_type === "latest") {
        $order_by = "ORDER BY id DESC";
        $by_item_status = "status IS NOT NULL";
    } else if ($order_type === "old") {
        $order_by = "ORDER BY id ASC";
        $by_item_status = "status IS NOT NULL";
    } else if ($order_type === "pending") {
        $order_by = "ORDER BY id DESC";
        $by_item_status = "status = 0";  // 0 = pending
    } else if ($order_type === "resolved") {
        $order_by = "ORDER BY id DESC";
        $by_item_status = "status = 1";  // 1 = resolved
    } else if ($order_type === "pending_old") {
        $order_by = "ORDER BY id ASC";
        $by_item_status = "status = 0";  // 0 = pending
    } else if ($order_type === "resolved_old") {
        $order_by = "ORDER BY id ASC";
        $by_item_status = "status = 1";  // 1 = resolved
    }
    // ------ Filter by Type --------
    else {
        $by_item_status .= " && type = '$order_type' ";
    }
}

// Get distinct types for the dropdown
$types_result = mysqli_query(getConn(), "SELECT DISTINCT type FROM reports WHERE type IS NOT NULL AND type != '' ORDER BY type");
$types = [];
while ($type_row = mysqli_fetch_assoc($types_result)) {
    $types[] = $type_row['type'];
}

// Get distinct reported types for the dropdown
$reported_types_result = mysqli_query(getConn(), "SELECT DISTINCT reported_type FROM reports WHERE reported_type IS NOT NULL AND reported_type != '' ORDER BY reported_type");
$reported_types = [];
while ($reported_type_row = mysqli_fetch_assoc($reported_types_result)) {
    $reported_types[] = $reported_type_row['reported_type'];
}

$totalItems = mysqli_num_rows(mysqli_query(getConn(), "SELECT * FROM reports WHERE $by_item_status $order_by"));

if (isset($_GET['q'])) {
    $search = mysqli_real_escape_string(getConn(), $_GET['q']);
    $search_query = "q=$search&";

    if (is_numeric($search)) {
        $qItem = "SELECT * FROM reports  
        WHERE id = $search || user_id = $search || extra LIKE '%$search%' && $by_item_status $order_by LIMIT 10";
    } else {
        $qItem = "SELECT * FROM reports  
        WHERE lower(type) LIKE lower('%$search%') || lower(message) LIKE lower('%$search%') || lower(reported_type) LIKE lower('%$search%') || lower(extra) LIKE lower('%$search%') && $by_item_status $order_by LIMIT $start,$per_page";
    }

    $items = mysqli_query(getConn(), $qItem);

    $totalItems = mysqli_num_rows(mysqli_query(getConn(), "SELECT * FROM reports  
    WHERE lower(type) LIKE lower('%$search%') || lower(message) LIKE lower('%$search%') || lower(reported_type) LIKE lower('%$search%') || lower(extra) LIKE lower('%$search%') && $by_item_status $order_by"));
} else {
    $search = "Search Here...";
    $items = mysqli_query(getConn(), "SELECT * FROM reports WHERE $by_item_status $order_by LIMIT $start,$per_page");
}

// =====Pagination====
$totalPage = ceil($totalItems / $per_page);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <?php getHead("Reports"); ?>
</head>

<body>
    <?php require_once("includes/header.php"); ?>

    <div class="table_header">
        <div>
            <form action="" method="get" id="search_f">
                <input type="hidden" name="order" value="<?php echo $order_type ?>">
                <input type="search" name="q" id="search" placeholder="<?php echo $search ?>">
                <input type="submit" value="Search">
            </form>
        </div>

        <div class="filters">
            <div class="filter">
                <select name="order" id="order" onchange="changeOrder(this.value)">
                    <optgroup label="ORDER">
                        <option value="latest" <?php echo $order_type == "latest" ? "selected" : ""; ?>>All Latest Reports</option>
                        <option value="old" <?php echo $order_type == "old" ? "selected" : ""; ?>>All Old Reports</option>
                        <option value="pending" <?php echo $order_type == "pending" ? "selected" : ""; ?>>Pending (0)</option>
                        <option value="resolved" <?php echo $order_type == "resolved" ? "selected" : ""; ?>>Resolved (1)</option>
                        <option value="pending_old" <?php echo $order_type == "pending_old" ? "selected" : ""; ?>>Pending (OLD)</option>
                        <option value="resolved_old" <?php echo $order_type == "resolved_old" ? "selected" : ""; ?>>Resolved (OLD)</option>
                    </optgroup>

                    <optgroup label="BY Type">
                        <?php
                        // Automatically populate types from database
                        foreach ($types as $type) {
                            $selected = $order_type == $type ? "selected" : "";
                            echo "<option value=\"$type\" $selected>$type</option>";
                        }
                        ?>
                    </optgroup>

                    <optgroup label="BY Reported Type">
                        <?php
                        // Automatically populate reported types from database
                        foreach ($reported_types as $reported_type) {
                            $selected = $order_type == $reported_type ? "selected" : "";
                            echo "<option value=\"$reported_type\" $selected>$reported_type</option>";
                        }
                        ?>
                    </optgroup>
                </select>
            </div>
        </div>
    </div>

    <script>
        function changeOrder(val) {
            let orderElement = document.createElement("a");
            orderElement.setAttribute("href", "?order=" + val);
            orderElement.click();
        }
    </script>

    <table class="caption-top">
        <caption>Reports</caption>
        <tr>
            <th>ID</th>
            <th>Type</th>
            <th>Reported Type</th>
            <th>Message</th>
            <th>Extra Info</th>
            <th>Status</th>
            <th>Date</th>
            <th>Action</th>
        </tr>

        <?php
        while ($r = mysqli_fetch_assoc($items)) {
            $id = $r['id'];
            $user_id = $r['user_id'];
            $type = $r['type'];
            $reported_type = $r['reported_type'];
            $message = $r['message'];
            $extra = $r['extra'];
            $status = $r['status']; // This is now 0 or 1
            $date = date("d-M-Y", strtotime($r['date']));
            $time = date("H:i:s", strtotime($r['date']));

            $display_date = $date . "<br>" . $time;
            $full_message = htmlspecialchars($message, ENT_QUOTES, 'UTF-8');
            $full_extra = htmlspecialchars($extra, ENT_QUOTES, 'UTF-8');

            // Format message for display in table
            if (strlen($message) > 50) {
                $display_message = substr($message, 0, 50) . "...";
            } else {
                $display_message = $message;
            }

            // Format extra info for display in table
            if (strlen($extra) > 30) {
                $display_extra = substr($extra, 0, 30) . "...";
            } else {
                $display_extra = $extra;
            }

            // Convert status number to text for display
            $status_text = $status == 1 ? "Resolved" : "Pending";
        ?>
            <tr>
                <td><?php echo $id ?></td>
                <td><?php echo $type ?></td>
                <td><?php echo $reported_type ?></td>
                <td class="fill"><?php echo $display_message ?></td>
                <td class="fill"><?php echo $display_extra ?></td>
                <td>
                    <span class="status-badge status-<?php echo $status ?>"><?php echo $status_text ?> (<?php echo $status ?>)</span>
                </td>
                <td><?php echo $display_date ?></td>
                <td class="actions">
                    <input type="checkbox" <?php echo $status == 1 ? "checked" : ""; ?> onclick="changeStatus('<?php echo $id ?>',this,'report')" title="Mark as resolved">

                    <?php if (!empty($user_id)): ?>
                        <a href="users_profile.php?id=<?php echo $user_id ?>&edit=false" class="orange"><i class="bx bx-user"></i></a>
                    <?php endif; ?>

                    <a class="green view-report-btn"
                        data-type="<?= htmlspecialchars($type, ENT_QUOTES, 'UTF-8') ?>"
                        data-reported-type="<?= htmlspecialchars($reported_type, ENT_QUOTES, 'UTF-8') ?>"
                        data-date="<?= htmlspecialchars($date, ENT_QUOTES, 'UTF-8') ?>"
                        data-time="<?= htmlspecialchars($time, ENT_QUOTES, 'UTF-8') ?>"
                        data-status="<?= $status_text ?>"
                        data-extra="<?= $full_extra ?>"
                        data-message="<?= $full_message ?>">
                        <i class="bx bx-show-alt"></i>
                    </a>

                    <a onclick="deleteItem('<?php echo $id ?>','delete_report')" class="red"><i class="bx bx-trash"></i></a>
                </td>
            </tr>
        <?php
        }
        ?>
    </table>

    <!-- ===============Pagination=============== -->
    <?php generatePagination($page, $totalPage, "?" . $order_url . $search_query); ?>

    <?php require_once("includes/footer.php"); ?>

    <!--=============================== Modal =======================-->
    <div class="modal fade" id="reportModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Report Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <p><strong>Type:</strong> <span id="modalType"></span></p>
                        </div>
                        <div class="col-md-4">
                            <p><strong>Reported Type:</strong> <span id="modalReportedType"></span></p>
                        </div>
                        <div class="col-md-4">
                            <p><strong>Status:</strong> <span id="modalStatus"></span></p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <p><strong>Date:</strong> <span id="modalDate"></span></p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Time:</strong> <span id="modalTime"></span></p>
                        </div>
                    </div>
                    <div class="mb-3">
                        <p><strong>Extra Information:</strong></p>
                        <div class="p-3 bg-light rounded" id="modalExtra" style="white-space: pre-wrap;"></div>
                    </div>
                    <div class="mb-3">
                        <p><strong>Message:</strong></p>
                        <div class="p-3 bg-light rounded" id="modalMessage" style="white-space: pre-wrap;"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Handle all view report buttons
            document.querySelectorAll('.view-report-btn').forEach(btn => {
                btn.addEventListener('click', function() {
                    // Get data attributes
                    const type = this.getAttribute('data-type');
                    const reportedType = this.getAttribute('data-reported-type');
                    const date = this.getAttribute('data-date');
                    const time = this.getAttribute('data-time');
                    const status = this.getAttribute('data-status');
                    const extra = this.getAttribute('data-extra');
                    const message = this.getAttribute('data-message');

                    // Set modal content
                    document.getElementById('modalType').textContent = type;
                    document.getElementById('modalReportedType').textContent = reportedType;
                    document.getElementById('modalDate').textContent = date;
                    document.getElementById('modalTime').textContent = time;
                    document.getElementById('modalStatus').textContent = status;
                    document.getElementById('modalExtra').textContent = extra;
                    document.getElementById('modalMessage').textContent = message;

                    // Show modal
                    const modal = new bootstrap.Modal(document.getElementById('reportModal'));
                    modal.show();
                });
            });
        });
    </script>
</body>

</html>