<?php

require_once('app.php');

$date = date("Y-m-d H:i:s");

// Get distinct tags from category table (these will be our main categories)
$main_categories = mysqli_query(getConn(), "SELECT DISTINCT tag FROM category WHERE status = 1");
// Get all categories for subcategory selection
$all_categories = mysqli_query(getConn(), "SELECT * FROM category WHERE status = 1");

if (isset($_POST['add'])) {

    $user_id =  mysqli_real_escape_string(getConn(), $_POST['user_id']);
    $views=  mysqli_real_escape_string(getConn(), $_POST['views']);
    $category_id =  mysqli_real_escape_string(getConn(), $_POST['category_id']);
    $title =  mysqli_real_escape_string(getConn(), $_POST['title']);
    $details =  mysqli_real_escape_string(getConn(), $_POST['details']);
    $prompt =  mysqli_real_escape_string(getConn(), $_POST['prompt']);
    $cover_url =  mysqli_real_escape_string(getConn(), $_POST['cover_url']);
    $tag =  mysqli_real_escape_string(getConn(), $_POST['tag']);
    $keywords =  mysqli_real_escape_string(getConn(), $_POST['keywords']);
    $status =  mysqli_real_escape_string(getConn(), $_POST['status']);

    $path = "../uploads/Prompts/";
    if (!file_exists($path)) {
        mkdir($path, 0777, true);
    }

    if (!empty($_FILES['cover']['name'])) {

        $source_file = $_FILES['cover']['tmp_name'];

        $file_name = "PROMPT_" . date("YmdHis") . "_" . random(8) . getExtension($_FILES['cover']['name']);

        if (move_uploaded_file($source_file, ($path . $file_name))) {
            $cover_url = "Prompts/" . $file_name;
        }
    }

    $q = mysqli_query(getConn(), "INSERT INTO `prompts`(`user_id`, `category_id`, `title`, `details`, `prompt`, `cover`, `tag`, `keywords`, `views`,  `status`, `date`) VALUES ('$user_id','$category_id','$title','$details','$prompt','$cover_url','$tag','$keywords','$views','$status','$date')");

    if ($q) {
        echo "<script>history.go(-2);</script>";
    } else {
        echo "<script>showAlert('Sorry','Something went wrong..')</script>";
    }
}

if (isset($_POST['update'])) {

    $update_id =  mysqli_real_escape_string(getConn(), $_POST['id']);
    $user_id =  mysqli_real_escape_string(getConn(), $_POST['user_id']);
    $views=  mysqli_real_escape_string(getConn(), $_POST['views']);
    $category_id =  mysqli_real_escape_string(getConn(), $_POST['category_id']);
    $title =  mysqli_real_escape_string(getConn(), $_POST['title']);
    $details =  mysqli_real_escape_string(getConn(), $_POST['details']);
    $prompt =  mysqli_real_escape_string(getConn(), $_POST['prompt']);
    $cover_url =  mysqli_real_escape_string(getConn(), $_POST['cover_url']);
    $tag =  mysqli_real_escape_string(getConn(), $_POST['tag']);
    $keywords =  mysqli_real_escape_string(getConn(), $_POST['keywords']);
    $status =  mysqli_real_escape_string(getConn(), $_POST['status']);

    $path = "../uploads/Prompts/";

    if (!file_exists($path)) {
        mkdir($path, 0777, true);
    }

    if (!empty($_FILES['cover']['name'])) {

        $source_file = $_FILES['cover']['tmp_name'];

        $file_name = "PROMPT_" . date("YmdHis") . "_" . random(8) . getExtension($_FILES['cover']['name']);

        if (move_uploaded_file($source_file, ($path . $file_name))) {
            $cover_url = "Prompts/" . $file_name;
        }
    }

    $q = mysqli_query(getConn(), "UPDATE `prompts` SET `user_id`='$user_id',`category_id`='$category_id',`title`='$title',`details`='$details',`prompt`='$prompt',`cover`='$cover_url',`tag`='$tag',`keywords`='$keywords',`views`='$views',`status`='$status',`modified_date`='$date' WHERE id = $update_id LIMIT 1");

    if ($q) {
        echo "<script>history.go(-2);</script>";
    } else {
        echo "<script>showAlert('Sorry','Something went wrong..')</script>";
    }
}

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php getHead("Prompts Action"); ?>
    <link rel="stylesheet" href="<?php echo ASSET_URL ?>libs/editor/jodit.min.css" />
</head>

<style>
    .tag-input-container {
        position: relative;
        width: 100%;
    }

    .tags-input {
        display: flex;
        flex-wrap: wrap;
        align-items: center;
        border: 1px solid #ddd;
        border-radius: 4px;
        padding: 5px;
        min-height: 38px;
    }

    .tag {
        background: #007bff;
        color: white;
        padding: 2px 8px;
        border-radius: 3px;
        margin: 2px;
        display: flex;
        align-items: center;
    }

    .tag-remove {
        margin-left: 5px;
        cursor: pointer;
        font-weight: bold;
    }

    .tag-input {
        border: none;
        outline: none;
        flex: 1;
        min-width: 100px;
        padding: 5px;
    }

    textarea {
        width: 100%;
        min-height: 100px;
        padding: 10px;
        border: 1px solid #ddd;
        border-radius: 4px;
    }

    fieldset {
        margin-bottom: 20px;
        padding: 15px;
        border: 1px solid #ddd;
        border-radius: 5px;
    }

    legend {
        font-weight: bold;
        padding: 0 10px;
    }

    .input {
        margin-bottom: 15px;
    }

    .input label {
        display: block;
        margin-bottom: 5px;
        font-weight: bold;
    }

    .input input,
    .input select,
    .input textarea {
        width: 100%;
        padding: 8px;
        border: 1px solid #ddd;
        border-radius: 4px;
    }

    .input.img {
        display: flex;
        align-items: flex-start;
        gap: 15px;
    }

    .input.img label img {
        width: 150px;
        height: 150px;
        object-fit: cover;
        border: 1px solid #ddd;
        border-radius: 4px;
        cursor: pointer;
    }

    .input.img .inputs {
        flex: 1;
    }

    #submit_button {
        background: #007bff;
        color: white;
        padding: 10px 20px;
        border: none;
        border-radius: 4px;
        cursor: pointer;
        font-size: 16px;
    }

    #submit_button:hover {
        background: #0056b3;
    }

    .subcategory-container {
        margin-top: 10px;
    }

    #subcategory_id {
        display: none;
    }
</style>

<body>
    <?php include_once('includes/header.php');

    if (isset($_GET['id'])) {
        $id = $_GET['id'];
        $prompt = mysqli_fetch_assoc(mysqli_query(getConn(), "SELECT * FROM prompts WHERE id = $id LIMIT 1"));

        // Get the selected category details to pre-select the main category
        $selected_category = mysqli_fetch_assoc(mysqli_query(getConn(), "SELECT * FROM category WHERE id = " . $prompt['category_id']));
        $selected_tag = $selected_category ? $selected_category['tag'] : '';
    ?>

        <form action="" method="POST" enctype="multipart/form-data">
            <input type="hidden" name="id" value="<?php echo $id; ?>">

            <fieldset>
                <legend>Basic Information</legend>

                <div class="input">
                    <label for="user_id">User ID:</label>
                    <input type="number" id="user_id" name="user_id" value="<?php echo $prompt['user_id']; ?>" required>
                </div>
                
                <div class="input">
                    <label for="views">Views :</label>
                    <input type="number" id="views" name="views" value="<?php echo $prompt['views']; ?>" required>
                </div>

                <div class="input">
                    <label for="main_category">Main Category (Tag):</label>
                    <select name="main_category" id="main_category" required onchange="loadSubcategories(this.value)">
                        <option value="">Select Main Category</option>
                        <?php
                        mysqli_data_seek($main_categories, 0);
                        while ($cat = mysqli_fetch_assoc($main_categories)) {
                        ?>
                            <option value="<?php echo $cat['tag']; ?>" <?php echo $cat['tag'] == $selected_tag ? "selected" : ""; ?>>
                                <?php echo $cat['tag']; ?>
                            </option>
                        <?php } ?>
                    </select>
                </div>

                <div class="input">
                    <label for="subcategory_id">Sub Category (Title):</label>
                    <div id="subcategory_container" class="subcategory-container">
                        <select name="subcategory_id" id="subcategory_id" onchange="document.getElementById('category_id').value = this.value">
                            <option value="">Select Sub Category</option>
                            <?php
                            if ($selected_tag) {
                                $subcategories = mysqli_query(getConn(), "SELECT * FROM category WHERE tag = '$selected_tag' AND status = 1");
                                while ($subcat = mysqli_fetch_assoc($subcategories)) {
                            ?>
                                    <option value="<?php echo $subcat['id']; ?>" <?php echo $subcat['id'] == $prompt['category_id'] ? "selected" : ""; ?>>
                                        <?php echo $subcat['title']; ?>
                                    </option>
                            <?php
                                }
                            }
                            ?>
                        </select>
                    </div>
                    <input type="hidden" id="category_id" name="category_id" value="<?php echo $prompt['category_id']; ?>" required>
                </div>

                <div class="input">
                    <label for="title">Prompt Title:</label>
                    <input type="text" id="title" name="title" value="<?php echo $prompt['title']; ?>" required>
                </div>
            </fieldset>

            <fieldset id="file_one">
                <legend>Cover Image</legend>
                <div class="input img">
                    <label for="cover">
                        <img src="<?php echo getImage($prompt['cover']); ?>" id="cover_img">
                    </label>
                    <div class="inputs">
                        <input type="file" name="cover" id="cover" onchange="PreviewImage();" accept="image/jpg,image/jpeg,image/png" />
                        <input type="text" id="cover_url" name="cover_url" value="<?php echo $prompt['cover']; ?>">
                    </div>
                </div>
            </fieldset>

            <fieldset>
                <legend>Content</legend>

                <div class="input">
                    <label for="details">Details:</label>
                    <textarea id="details" name="details"><?php echo $prompt['details']; ?></textarea>
                </div>

                <div class="input">
                    <label for="prompt">Prompt:</label>
                    <textarea id="prompt" name="prompt" placeholder="Enter the main prompt content here..." required><?php echo $prompt['prompt']; ?></textarea>
                </div>
            </fieldset>

            <fieldset>
                <legend>Tags & Keywords</legend>

                <div class="input">
                    <label for="tag_input">Tags (separate with commas or press Enter):</label>
                    <div class="tag-input-container">
                        <div class="tags-input" id="tagContainer">
                            <!-- Tags will be added here dynamically -->
                        </div>
                        <br>
                        <input type="text" id="tag_input" class="tag-input" placeholder="Type tags and press Enter or comma...">
                        <input type="hidden" id="tag" name="tag" value="<?php echo $prompt['tag']; ?>">
                    </div>
                </div>

                <div class="input">
                    <label for="keyword_input">Keywords (separate with commas or press Enter):</label>
                    <div class="tag-input-container">
                        <div class="tags-input" id="keywordContainer">
                            <!-- Keywords will be added here dynamically -->
                        </div>
                        <br>
                        <input type="text" id="keyword_input" class="tag-input" placeholder="Type keywords and press Enter or comma...">
                        <input type="hidden" id="keywords" name="keywords" value="<?php echo $prompt['keywords']; ?>">
                    </div>
                </div>
            </fieldset>

            <div class="input">
                <label for="status">Status:</label>
                <select name="status" id="status" required>
                    <option value="1" <?php echo $prompt['status'] == "1" ? "selected" : ""; ?>>Enabled</option>
                    <option value="0" <?php echo $prompt['status'] == "0" ? "selected" : ""; ?>>Disabled</option>
                </select>
            </div>

            <input type="submit" value="Update Prompt" name="update" id="submit_button">
        </form>

    <?php } else { ?>

        <form action="" method="POST" enctype="multipart/form-data">

            <fieldset>
                <legend>Basic Information</legend>

                <div class="input">
                    <label for="user_id">User ID:</label>
                    <input type="number" id="user_id" name="user_id" value="1" required>
                </div>
                
                <div class="input">
                    <label for="views">views :</label>
                    <input type="number" id="views" name="views" value="<?php echo randomNum(4)?>" required>
                </div>

                <div class="input">
                    <label for="main_category">Main Category (Tag):</label>
                    <select name="main_category" id="main_category" required onchange="loadSubcategories(this.value)">
                        <option value="">Select Main Category</option>
                        <?php
                        mysqli_data_seek($main_categories, 0);
                        while ($cat = mysqli_fetch_assoc($main_categories)) {
                        ?>
                            <option value="<?php echo $cat['tag']; ?>"><?php echo $cat['tag']; ?></option>
                        <?php } ?>
                    </select>
                </div>

                <div class="input">
                    <label for="subcategory_id">Sub Category (Title):</label>
                    <div id="subcategory_container" class="subcategory-container">
                        <select name="subcategory_id" id="subcategory_id" onchange="document.getElementById('category_id').value = this.value">
                            <option value="">First select Main Category</option>
                        </select>
                    </div>
                    <input type="hidden" id="category_id" name="category_id" value="" required>
                </div>

                <div class="input">
                    <label for="title">Prompt Title:</label>
                    <input type="text" id="title" name="title" value="" required>
                </div>
            </fieldset>

            <fieldset id="file_one">
                <legend>Cover Image</legend>
                <div class="input img">
                    <label for="cover">
                        <img src="<?php echo getImage(''); ?>" id="cover_img">
                    </label>
                    <div class="inputs">
                        <input type="file" name="cover" id="cover" onchange="PreviewImage();" accept="image/jpg,image/jpeg,image/png" />
                        <input type="text" id="cover_url" name="cover_url" value="">
                    </div>
                </div>
            </fieldset>

            <fieldset>
                <legend>Content</legend>

                <div class="input">
                    <label for="details">Details:</label>
                    <textarea id="details" name="details"></textarea>
                </div>

                <div class="input">
                    <label for="prompt">Prompt:</label>
                    <textarea id="prompt" name="prompt" placeholder="Enter the main prompt content here..." required></textarea>
                </div>
            </fieldset>

            <fieldset>
                <legend>Tags & Keywords</legend>

                <div class="input">
                    <label for="tag_input">Tags (separate with commas or press Enter):</label>
                    <div class="tag-input-container">
                        <div class="tags-input" id="tagContainer">
                            <!-- Tags will be added here dynamically -->
                        </div>
                        <br>
                        <input type="text" id="tag_input" class="tag-input" placeholder="Type tags and press Enter or comma...">
                        <input type="hidden" id="tag" name="tag" value="">
                    </div>
                </div>

                <div class="input">
                    <label for="keyword_input">Keywords (separate with commas or press Enter):</label>
                    <div class="tag-input-container">
                        <div class="tags-input" id="keywordContainer">
                            <!-- Keywords will be added here dynamically -->
                        </div>
                        <br>
                        <input type="text" id="keyword_input" class="tag-input" placeholder="Type keywords and press Enter or comma...">
                        <input type="hidden" id="keywords" name="keywords" value="">
                    </div>
                </div>
            </fieldset>

            <div class="input">
                <label for="status">Status:</label>
                <select name="status" id="status" required>
                    <option value="1" selected>Enabled</option>
                    <option value="0">Disabled</option>
                </select>
            </div>

            <input type="submit" value="Add Prompt" name="add" id="submit_button">
        </form>

    <?php } ?>

    <script src="<?php echo ASSET_URL ?>libs/editor/jodit.min.js"></script>
    <script>
        // Initialize Jodit Editor for details field
        try {
            const detailsEditor = Jodit.make('#details', {
                height: 300,
                buttons: ['bold', 'italic', 'underline', 'strikethrough', '|',
                    'ul', 'ol', '|', 'font', 'fontsize', 'brush', '|',
                    'align', 'outdent', 'indent', '|', 'link', 'image', 'video',
                    'table', '|', 'undo', 'redo', '|', 'source'
                ]
            });
        } catch (e) {
            console.error('Editor initialization error:', e);
        }

        // Image preview function
        function PreviewImage() {
            var oFReader = new FileReader();
            oFReader.readAsDataURL(document.getElementById("cover").files[0]);
            oFReader.onload = function(oFREvent) {
                document.getElementById("cover_img").src = oFREvent.target.result;
            };
        }

        // Load subcategories based on selected main category (tag)
        function loadSubcategories(tag) {
            const subcategorySelect = document.getElementById('subcategory_id');
            const categoryIdInput = document.getElementById('category_id');

            if (!tag) {
                subcategorySelect.innerHTML = '<option value="">First select Main Category</option>';
                subcategorySelect.style.display = 'none';
                categoryIdInput.value = '';
                return;
            }

            // Fetch subcategories via AJAX
            const xhr = new XMLHttpRequest();
            xhr.open('POST', 'ajax/category.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onload = function() {
                if (this.status === 200) {
                    const categories = JSON.parse(this.responseText);
                    subcategorySelect.innerHTML = '<option value="">Select Sub Category</option>';

                    if (categories.length > 0) {
                        categories.forEach(cat => {
                            const option = document.createElement('option');
                            option.value = cat.id;
                            option.textContent = cat.title;
                            subcategorySelect.appendChild(option);
                        });
                        subcategorySelect.style.display = 'block';
                    } else {
                        subcategorySelect.innerHTML = '<option value="">No subcategories found</option>';
                        subcategorySelect.style.display = 'block';
                    }
                }
            };
            xhr.send('tag=' + encodeURIComponent(tag));
        }

        // Tag and Keyword input functionality
        function initTagInput(inputId, containerId, hiddenInputId, initialValue) {
            const input = document.getElementById(inputId);
            const container = document.getElementById(containerId);
            const hiddenInput = document.getElementById(hiddenInputId);

            // Initialize with existing values
            if (initialValue) {
                const values = initialValue.split(',').map(v => v.trim()).filter(v => v);
                values.forEach(value => {
                    addTag(value, container, hiddenInput);
                });
            }

            input.addEventListener('keydown', function(e) {
                if (e.key === 'Enter' || e.key === ',') {
                    e.preventDefault();
                    const value = this.value.trim();
                    if (value) {
                        addTag(value, container, hiddenInput);
                        this.value = '';
                    }
                }
            });

            input.addEventListener('blur', function() {
                const value = this.value.trim();
                if (value) {
                    addTag(value, container, hiddenInput);
                    this.value = '';
                }
            });
        }

        function addTag(value, container, hiddenInput) {
            if (!value) return;

            const tag = document.createElement('div');
            tag.className = 'tag';
            tag.innerHTML = `
                ${value}
                <span class="tag-remove" onclick="removeTag(this)">×</span>
            `;
            container.insertBefore(tag, container.lastElementChild);

            updateHiddenInput(container, hiddenInput);
        }

        function removeTag(element) {
            element.parentElement.remove();
            const container = element.closest('.tags-input');
            const hiddenInput = document.getElementById(container.nextElementSibling.id);
            updateHiddenInput(container, hiddenInput);
        }

        function updateHiddenInput(container, hiddenInput) {
            const tags = Array.from(container.querySelectorAll('.tag'))
                .map(tag => tag.firstChild.textContent.trim())
                .filter(tag => tag);
            hiddenInput.value = tags.join(',');
        }

        // Initialize tag and keyword inputs
        document.addEventListener('DOMContentLoaded', function() {
            const tagValue = document.getElementById('tag') ? document.getElementById('tag').value : '';
            const keywordsValue = document.getElementById('keywords') ? document.getElementById('keywords').value : '';

            initTagInput('tag_input', 'tagContainer', 'tag', tagValue);
            initTagInput('keyword_input', 'keywordContainer', 'keywords', keywordsValue);

            // Load subcategories if editing and main category is selected
            <?php if (isset($_GET['id']) && !empty($selected_tag)): ?>
                loadSubcategories('<?php echo $selected_tag; ?>');
                document.getElementById('subcategory_id').style.display = 'block';
            <?php endif; ?>
        });
    </script>

    <?php include_once('includes/footer.php'); ?>
</body>

</html>