<?php

require_once('app.php');

if (isset($_GET['page'])) {
    $page = $_GET['page'];
    if ($page <= 0) {
        $page = 1;
    }
} else {
    $page = 1;
}

$per_page = 30;

$start = ($page - 1) * $per_page;

$search_query = "";

$order_url = "";
$order_type = "latest";
$order_by = "ORDER BY id DESC";

$by_item_status = "status > 0";

// New filter parameters
$views_filter = "";
$tags_filter = "";
$keywords_filter = "";

if (isset($_GET['order'])) {
    $order_type = $_GET['order'];
    $order_url = "order=" . $order_type . "&";

    if ($order_type === "unverified") {
        $by_item_status = "status = 0";
    } else if ($order_type === "verified") {
        $by_item_status = "status = 1";
    } else if ($order_type == "all") {
        $by_item_status = "status >= 0";
    } else if ($order_type === "old") {
        $order_by = "ORDER BY id ASC";
    } else if ($order_type === "popular") {
        $order_by = "ORDER BY views DESC";
    } else if ($order_type === "least_popular") {
        $order_by = "ORDER BY views ASC";
    } else {
        $order_by = "ORDER BY id DESC";
    }
}

// Handle views filter
if (isset($_GET['views']) && !empty($_GET['views'])) {
    $views_filter = $_GET['views'];
    $order_url .= "views=" . $views_filter . "&";

    if ($views_filter === "high") {
        $order_by = "ORDER BY views DESC";
    } else if ($views_filter === "low") {
        $order_by = "ORDER BY views ASC";
    }
}

// Handle tags filter
if (isset($_GET['tags']) && !empty($_GET['tags'])) {
    $tags_filter = $_GET['tags'];
    $order_url .= "tags=" . $tags_filter . "&";
}

// Handle keywords filter
if (isset($_GET['keywords']) && !empty($_GET['keywords'])) {
    $keywords_filter = $_GET['keywords'];
    $order_url .= "keywords=" . $keywords_filter . "&";
}

// Base query conditions
$where_conditions = array($by_item_status);

// Add tags filter condition
if (!empty($tags_filter)) {
    $where_conditions[] = "tag LIKE '%" . mysqli_real_escape_string($conn, $tags_filter) . "%'";
}

// Add keywords filter condition
if (!empty($keywords_filter)) {
    $where_conditions[] = "keywords LIKE '%" . mysqli_real_escape_string($conn, $keywords_filter) . "%'";
}

$where_clause = implode(" AND ", $where_conditions);

$totalItems = mysqli_num_rows(mysqli_query($conn, "SELECT `id` FROM prompts WHERE $where_clause $order_by"));

if (isset($_GET['q'])) {
    $search = $_GET['q'];
    $search_query = "q=$search&";

    // Search in multiple fields: title, details, tag, keywords, prompt
    $search_condition = "(LOWER(title) LIKE LOWER('%$search%') OR 
                         LOWER(details) LIKE LOWER('%$search%') OR 
                         LOWER(tag) LIKE LOWER('%$search%') OR 
                         LOWER(keywords) LIKE LOWER('%$search%') OR 
                         LOWER(prompt) LIKE LOWER('%$search%'))";

    $qItem;
    if (is_numeric($search)) {
        $qItem = "SELECT * FROM `prompts` 
        WHERE id = $search AND $where_clause $order_by LIMIT 10";
    } else {
        $qItem = "SELECT * FROM prompts 
        WHERE $search_condition AND $where_clause $order_by LIMIT $start,$per_page";
    }

    $items = mysqli_query($conn, $qItem);

    $totalItems = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM prompts 
    WHERE $search_condition AND $where_clause $order_by"));
} else {
    $search = "Search Here...";
    $items = mysqli_query($conn, "SELECT * FROM prompts WHERE $where_clause $order_by limit $start,$per_page");
}

// =====Pagination====
$totalPage = ceil($totalItems / $per_page);

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <?php getHead("Prompts"); ?>
</head>

<body>
    <?php include_once('includes/header.php'); ?>

    <div class="table_header">
        <div>
            <form action="" method="get" id="search_f">
                <input type="hidden" name="order" value="<?php echo $order_type ?>">

                <input type="search" name="q" id="search" placeholder="<?php echo $search ?>" value="<?php echo isset($_GET['q']) ? $_GET['q'] : '' ?>">
                <input type="submit" value="Search">

                <!-- Views Filter -->
                <select name="views" id="views" onchange="this.form.submit()">
                    <option value="">All Views</option>
                    <option value="high" <?php echo $views_filter == "high" ? "selected" : ""; ?>>High Views</option>
                    <option value="low" <?php echo $views_filter == "low" ? "selected" : ""; ?>>Low Views</option>
                </select>


                <!-- Tags Filter -->
                <input type="text" name="tags" placeholder="Filter by Tag" value="<?php echo $tags_filter ?>" onchange="this.form.submit()">

                <!-- Keywords Filter -->
                <input type="text" name="keywords" placeholder="Filter by Keywords" value="<?php echo $keywords_filter ?>" onchange="this.form.submit()">
            </form>
        </div>

        <select name="order" id="order" onchange="changeOrder(this.value)" style="width: max-content;">
            <option value="all" <?php echo $order_type == "all" ? "selected" : ""; ?>>All</option>
            <option value="unverified" <?php echo $order_type == "unverified" ? "selected" : ""; ?>>Disabled</option>
            <option value="verified" <?php echo $order_type == "verified" ? "selected" : ""; ?>>Enabled</option>
            <option value="latest" <?php echo $order_type == "latest" ? "selected" : ""; ?>>Latest</option>
            <option value="old" <?php echo $order_type == "old" ? "selected" : ""; ?>>Oldest</option>
            <option value="popular" <?php echo $order_type == "popular" ? "selected" : ""; ?>>Most Popular</option>
            <option value="least_popular" <?php echo $order_type == "least_popular" ? "selected" : ""; ?>>Least Popular</option>
        </select>

        <a href="prompts_action.php">Add More</a>

        <script>
            function changeOrder(val) {
                let orderElement = document.createElement("a");
                orderElement.setAttribute("href", "?order=" + val);
                orderElement.click();
            }
        </script>
    </div>

    <table class="caption-top">
        <caption>Prompts</caption>

        <tr>
            <th>ID</th>
            <th>Cover</th>
            <th>Title</th>
            <th>Category</th>
            <th>Views</th>
            <th>Tags</th>
            <th>Keywords</th>
            <th>Actions</th>
        </tr>

        <?php
        while ($r = mysqli_fetch_assoc($items)) {
            $id = $r['id'];
            $user_id = $r['user_id'];
            $category_id = $r['category_id'];
            $title = $r['title'];
            $details = $r['details'];
            $prompt = $r['prompt'];
            $cover = $r['cover'];
            $views = $r['views'];
            $tag = $r['tag'];
            $keywords = $r['keywords'];
            $status = $r['status'];
            $modified_date = $r['modified_date'];
            $date = $r['date'];
        ?>
            <tr>
                <td><?php echo $id ?></td>
                <td><img src="<?php echo getImage($cover); ?>" loading="lazy" id="cover"></td>
                <td><?php echo $title; ?></td>
                <td><?php echo $category_id ?></td>
                <td><?php echo counter($views) ?></td>
                <td><?php echo $tag ?></td>
                <td><?php echo $keywords ?></td>

                <td class="actions">
                    <input type="checkbox" <?php echo $status == "1" ? "checked" : ""; ?> onclick="changeStatus('<?php echo $id ?>',this,'prompts')" id="status" title="Enable/Disable">
                    <a href="prompts_action.php?id=<?php echo $id ?>" class="dodgerblue"><i class="bx bx-edit"></i></a>
                    <?php if ($status == "0") { ?>
                        <a onclick="deleteItem('<?php echo $id ?>','delete_prompts')" class="red" title="Delete Permanently"><i class="bx bx-trash"></i></a>
                    <?php } ?>
                </td>
            </tr>
        <?php
        }
        ?>
    </table>

    <!-- ===============Pagination=============== -->
    <?php generatePagination($page, $totalPage, "?" . $order_url . $search_query); ?>

    <!-- ===========================EXTRA SCRIPT============= -->
    <?php include_once('includes/footer.php'); ?>
</body>

</html>