function PreviewImage() {
    var oFReader = new FileReader();
    oFReader.readAsDataURL(document.getElementById("cover").files[0]);

    oFReader.onload = function (oFREvent) {
        document.getElementById("cover_img").src = oFREvent.target.result;
    };
}

function PreviewImages(elem, input) {
    var oFReader = new FileReader();
    oFReader.readAsDataURL(input.files[0]);

    oFReader.onload = function (oFREvent) {
        elem.src = oFREvent.target.result;
    };
}

function previewVideo(elem, input) {
    var oFReader = new FileReader();
    oFReader.readAsDataURL(input.files[0]);

    oFReader.onload = function (oFREvent) {
        elem.src = oFREvent.target.result;
        elem.style.display = "block";
    };
}




// ===================================== Models ================

// Bootstrap Modals and Alerts 

function showAlert(title, message) {
    return new Promise((resolve) => {
        const modal = new bootstrap.Modal(document.getElementById('alertModal'));
        document.getElementById('alertModalLabel').textContent = title;


        document.querySelector('#alertModal .modal-body').innerHTML = message.replace(/\n/g, '<br>');

        // Resolve the Promise when the modal is hidden
        const modalElement = document.getElementById('alertModal');
        modalElement.addEventListener('hidden.bs.modal', resolve);

        modal.show();
    });
}



// ========== Confirmation Modal Logic ==========


function showConfirm(message, action, callback) {

    const confirmModal = new bootstrap.Modal(document.getElementById('confirmModal'));
    const confirmActionBtn = document.getElementById('confirmActionBtn');
    const confirmMessage = document.getElementById('confirmMessage');
    let confirmCallback = null;

    confirmMessage.textContent = message;
    confirmActionBtn.textContent = action;
    confirmActionBtn.className = `btn btn-${action === 'Delete' ? 'danger' : 'primary'}`;
    confirmCallback = callback;
    confirmModal.show();

    confirmActionBtn.addEventListener('click', () => {
        if (confirmCallback) confirmCallback();
        confirmModal.hide();
    });
}


// ============================ Fire Ajax ===============

function changeStatus(id, check, type) {
    showLoader();
    if (check.checked) {
        setStatus(id, "1", type);
    } else {
        setStatus(id, "0", type);
    }
}


function setStatus(id, status, type) {
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            hideLoader();
        }
    };
    let url = "ajax/ajax.php?id=" + id + "&status=" + status + "&crud_type=" + type;
    xhttp.open("GET", url, true);
    xhttp.send();
}

function deleteItem(id, type) {

    showConfirm("Are you sure want to delete it", "Delete", () => {

        showLoader();

        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {

                hideLoader();

                let res = xhttp.responseText;
                if (res.includes("1")) {
                    location.reload();
                } else {
                    showAlert("Oops..!", "Failed to delete.");
                }
            }
        };
        let url = "ajax/ajax.php?crud_type=" + type + "&id=" + id;
        xhttp.open("GET", url, true);
        xhttp.send();

    });
}

