<?php

// --------------- Default Data -------------

define("SITE_NAME", "CX Admin");
define("BASE_URL", "https://aiprompt.kakabapu.com/");
define("ASSET_URL", BASE_URL . "assets/");
define("ADMIN_BASE", BASE_URL . "admin/");
define("CURRENCY", "₹");
define("TEMP_EMAIL", "@.com");



function getHead($title = SITE_NAME)
{
?>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $title; ?></title>
    <link rel="stylesheet" href="<?php echo ADMIN_BASE; ?>css/styles.css">
    <link rel="shortcut icon" href="<?php echo ASSET_URL; ?>img/fav.png" type="image/x-icon">

    <script src="<?php echo ADMIN_BASE; ?>js/main.js"></script>

    <link rel="stylesheet" href="<?php echo ASSET_URL; ?>libs/boxicons/css/boxicons.min.css">
    <script src="<?php echo ASSET_URL ?>libs/query/jquery.js"></script>

    <!-- ---- Bootstrap ---- -->

    <script src="<?php echo ASSET_URL ?>libs/boot/js/bootstrap.bundle.min.js" defer></script>
    <link href='<?php echo ASSET_URL ?>libs/boot/css/bootstrap.min.css' rel='stylesheet' />
<?php
}



// ======================== Logout ================

if (isset($_GET['logout'])) {
    unset($_SESSION["user"]);
    unset($_SESSION["password"]);
    session_destroy();
    header("Location:" . ADMIN_BASE);
    exit();
}


// -----------------------

// ================ Functions ===============

function cleanString($string)
{
    $string = str_replace(' ', '_', $string); // Replaces all spaces with hyphens.

    return (preg_replace('/[^A-Za-z0-9\-_]/', '', $string)); // Removes special chars.
}


function counter($num)
{

    if ($num > 1000) {

        $x = round($num);
        $x_number_format = number_format($x);
        $x_array = explode(',', $x_number_format);
        $x_parts = array('k+', 'm+', 'b+', 't+');
        $x_count_parts = count($x_array) - 1;
        $x_display = $x;
        $x_display = $x_array[0] . ((int) $x_array[1][0] !== 0 ? '.' . $x_array[1][0] : '');
        $x_display .= $x_parts[$x_count_parts - 1];

        return $x_display;
    }

    return $num;
}


function getImage($url)
{
    if (strlen($url) == 0) {
        return BASE_URL . "uploads/cover.png";
    } else if (substr($url, 0, 7) === "http://" || substr($url, 0, 4) === "http") {
        return $url;
    } else {
        return BASE_URL . "uploads/" . $url;
    }
}


function getProfile($url)
{
    if (substr($url, 0, 7) === "http://" || substr($url, 0, 4) === "http") {
        return $url;
    } else if (strlen($url) == 0) {
        return BASE_URL . "uploads/profile/sample.png";
    }
    return BASE_URL . "uploads/" . $url;
}




function moneyCounter($num)
{
    // Format as Indian currency with rupees and paise
    $formatted = number_format((float)$num, 2, '.', ',');

    return  $formatted;
}





function randomNum($len)
{
    $str_result = '0123456789';
    return substr(str_shuffle($str_result), 0, $len);
}

function randomChar($len)
{
    $str_result = '0123456789abcefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    return substr(str_shuffle($str_result), 0, $len);
}
function random($len)
{
    $str_result = '0123456789abcefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    return substr(str_shuffle($str_result), 0, $len);
}



function getExtension($file_name)
{
    return "." . pathinfo($file_name, PATHINFO_EXTENSION);
}



function generateSlug($title)
{
    $slug = strtolower($title);
    $slug = preg_replace('/[^a-z0-9]+/', '_', $slug);
    $slug = trim($slug, '_');
    return $slug;
}





function timeAgo($datetime, $full = false)
{
    $now = new DateTime;
    $ago = new DateTime($datetime);
    $diff = get_object_vars($now->diff($ago));
    $diff['w'] = floor($diff['d'] / 7);
    $diff['d'] -= $diff['w'] * 7;

    $string = array(
        'y' => 'year',
        'm' => 'month',
        'w' => 'weak',
        'd' => 'day',
        'h' => 'hour',
        'i' => 'min.',
        's' => 'sec.',
    );
    foreach ($string as $k => &$v) {

        if ($diff[$k]) {

            if ($k == 'm') {
                $v = $diff[$k] . ' ' . $v . ($diff[$k] > 1 ? '' : '');
            } else {
                $v = $diff[$k] . ' ' . $v . ($diff[$k] > 1 ? '' : '');
            }
        } else {
            unset($string[$k]);
        }
    }

    if (!$full) $string = array_slice($string, 0, 1);
    return $string ? implode(', ', $string) . ' ago' : 'just now';
}



function generatePagination($current_page, $total_pages, $base_url = '')
{
    if ($total_pages <= 1) {
        return '';
    }

    // Prepare base URL
    $url_params = [];
    if (empty($base_url)) {
        $url = parse_url($_SERVER['REQUEST_URI']);
        if (isset($url['query'])) {
            parse_str($url['query'], $url_params);
            unset($url_params['page']);
        }
        $base_url = $url['path'] . '?' . http_build_query($url_params);
        $base_url .= empty($url_params) ? '?' : '&';
    } else {
        $base_url = strpos($base_url, '?') === false ? $base_url . '?' : (substr($base_url, -1) !== '&' ? $base_url . '&' : $base_url);
    }

    // Generate pagination HTML
?>

    <div class="pagination">
        <?php if ($current_page > 1): ?>
            <a href="<?= $base_url ?>page=<?= $current_page - 1 ?>" class="pagination-nav">
                <i class="bx bx-chevron-left"></i>
            </a>
        <?php else: ?>
            <a class="pagination-nav disabled">
                <i class="bx bx-chevron-left"></i>
            </a>
        <?php endif; ?>

        <?php if ($current_page > 3): ?>
            <a href="<?= $base_url ?>page=1">1</a>
            <?php if ($current_page > 4): ?>
                <span class="ellipsis">...</span>
            <?php endif; ?>
        <?php endif; ?>

        <?php for ($i = max(1, $current_page - 2); $i <= min($total_pages, $current_page + 2); $i++): ?>
            <a <?= $i == $current_page ? 'class="active"' : '' ?>
                href="<?= $i == $current_page ? '#' : $base_url . 'page=' . $i ?>">
                <?= $i ?>
            </a>
        <?php endfor; ?>

        <?php if ($current_page < $total_pages - 2): ?>
            <?php if ($current_page < $total_pages - 3): ?>
                <span class="ellipsis">...</span>
            <?php endif; ?>
            <a href="<?= $base_url ?>page=<?= $total_pages ?>"><?= $total_pages ?></a>
        <?php endif; ?>

        <?php if ($current_page < $total_pages): ?>
            <a href="<?= $base_url ?>page=<?= $current_page + 1 ?>" class="pagination-nav">
                <i class="bx bx-chevron-right"></i>
            </a>
        <?php else: ?>
            <a class="pagination-nav disabled">
                <i class="bx bx-chevron-right"></i>
            </a>
        <?php endif; ?>
    </div>

<?php
}


?>