<?php
require_once("app.php");

// Get statistics
$total_prompts = mysqli_fetch_assoc(mysqli_query(getConn(), "SELECT COUNT(*) as total FROM prompts"))['total'];
$total_tools = mysqli_fetch_assoc(mysqli_query(getConn(), "SELECT COUNT(*) as total FROM tools"))['total'];
$total_categories = mysqli_fetch_assoc(mysqli_query(getConn(), "SELECT COUNT(*) as total FROM category"))['total'];
$total_users = mysqli_fetch_assoc(mysqli_query(getConn(), "SELECT COUNT(*) as total FROM users"))['total'];
$total_contacts = mysqli_fetch_assoc(mysqli_query(getConn(), "SELECT COUNT(*) as total FROM contact"))['total'];
$total_reports = mysqli_fetch_assoc(mysqli_query(getConn(), "SELECT COUNT(*) as total FROM reports"))['total'];

// Time period filter
$time_filter = isset($_GET['time_filter']) ? $_GET['time_filter'] : 'today';

// Get user activity based on time filter
switch ($time_filter) {
    case 'last_hour':
        $active_users_query = "SELECT COUNT(DISTINCT user_id) as total FROM users WHERE last_seen >= DATE_SUB(NOW(), INTERVAL 1 HOUR)";
        $user_growth_query = "SELECT COUNT(*) as total FROM users WHERE date >= DATE_SUB(NOW(), INTERVAL 1 HOUR)";
        $chart_days = 1;
        $chart_interval = 'HOUR';
        break;
    case 'yesterday':
        $active_users_query = "SELECT COUNT(DISTINCT user_id) as total FROM users WHERE DATE(last_seen) = DATE_SUB(CURDATE(), INTERVAL 1 DAY)";
        $user_growth_query = "SELECT COUNT(*) as total FROM users WHERE DATE(date) = DATE_SUB(CURDATE(), INTERVAL 1 DAY)";
        $chart_days = 1;
        $chart_interval = 'HOUR';
        break;
    case 'week':
        $active_users_query = "SELECT COUNT(DISTINCT user_id) as total FROM users WHERE last_seen >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)";
        $user_growth_query = "SELECT COUNT(*) as total FROM users WHERE date >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)";
        $chart_days = 7;
        $chart_interval = 'DAY';
        break;
    case 'month':
        $active_users_query = "SELECT COUNT(DISTINCT user_id) as total FROM users WHERE last_seen >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)";
        $user_growth_query = "SELECT COUNT(*) as total FROM users WHERE date >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)";
        $chart_days = 30;
        $chart_interval = 'DAY';
        break;
    case 'year':
        $active_users_query = "SELECT COUNT(DISTINCT user_id) as total FROM users WHERE last_seen >= DATE_SUB(CURDATE(), INTERVAL 365 DAY)";
        $user_growth_query = "SELECT COUNT(*) as total FROM users WHERE date >= DATE_SUB(CURDATE(), INTERVAL 365 DAY)";
        $chart_days = 12;
        $chart_interval = 'MONTH';
        break;
    case 'all_time':
        $active_users_query = "SELECT COUNT(DISTINCT user_id) as total FROM users";
        $user_growth_query = "SELECT COUNT(*) as total FROM users";
        $chart_days = 12;
        $chart_interval = 'MONTH';
        break;
    default: // today
        $active_users_query = "SELECT COUNT(DISTINCT user_id) as total FROM users WHERE DATE(last_seen) = CURDATE()";
        $user_growth_query = "SELECT COUNT(*) as total FROM users WHERE DATE(date) = CURDATE()";
        $chart_days = 1;
        $chart_interval = 'HOUR';
        break;
}

$active_users = mysqli_fetch_assoc(mysqli_query(getConn(), $active_users_query))['total'];
$new_users = mysqli_fetch_assoc(mysqli_query(getConn(), $user_growth_query))['total'];

// Get popular prompts (top 5 by views)
$popular_prompts = mysqli_query(
    getConn(),
    "SELECT id, title, views FROM prompts ORDER BY views DESC LIMIT 5"
);

// Get recent activities
$recent_contacts = mysqli_query(
    getConn(),
    "SELECT * FROM contact ORDER BY date DESC LIMIT 5"
);

$recent_reports = mysqli_query(
    getConn(),
    "SELECT * FROM reports ORDER BY date DESC LIMIT 5"
);

// Get user growth data for chart based on time filter
$user_growth_data = [];
$labels = [];
$data = [];

if ($time_filter == 'last_hour' || $time_filter == 'today' || $time_filter == 'yesterday') {
    // Hourly data for short periods
    for ($i = 23; $i >= 0; $i--) {
        $hour = date('H:00', strtotime("-$i hours"));
        $count = mysqli_fetch_assoc(mysqli_query(
            getConn(),
            "SELECT COUNT(*) as total FROM users WHERE HOUR(date) = HOUR(DATE_SUB(NOW(), INTERVAL $i HOUR)) AND DATE(date) = CURDATE()"
        ))['total'];
        $user_growth_data[] = [
            'label' => $hour,
            'count' => $count
        ];
    }
} elseif ($time_filter == 'week' || $time_filter == 'month') {
    // Daily data for medium periods
    for ($i = $chart_days - 1; $i >= 0; $i--) {
        $date = date('M j', strtotime("-$i days"));
        $count = mysqli_fetch_assoc(mysqli_query(
            getConn(),
            "SELECT COUNT(*) as total FROM users WHERE DATE(date) = DATE_SUB(CURDATE(), INTERVAL $i DAY)"
        ))['total'];
        $user_growth_data[] = [
            'label' => $date,
            'count' => $count
        ];
    }
} else {
    // Monthly data for long periods
    for ($i = $chart_days - 1; $i >= 0; $i--) {
        $month = date('M Y', strtotime("-$i months"));
        $count = mysqli_fetch_assoc(mysqli_query(
            getConn(),
            "SELECT COUNT(*) as total FROM users WHERE YEAR(date) = YEAR(DATE_SUB(NOW(), INTERVAL $i MONTH)) AND MONTH(date) = MONTH(DATE_SUB(NOW(), INTERVAL $i MONTH))"
        ))['total'];
        $user_growth_data[] = [
            'label' => $month,
            'count' => $count
        ];
    }
}

// Get additional stats for comparison
$today_active = mysqli_fetch_assoc(mysqli_query(
    getConn(),
    "SELECT COUNT(DISTINCT user_id) as total FROM users WHERE DATE(last_seen) = CURDATE()"
))['total'];

$yesterday_active = mysqli_fetch_assoc(mysqli_query(
    getConn(),
    "SELECT COUNT(DISTINCT user_id) as total FROM users WHERE DATE(last_seen) = DATE_SUB(CURDATE(), INTERVAL 1 DAY)"
))['total'];

$week_active = mysqli_fetch_assoc(mysqli_query(
    getConn(),
    "SELECT COUNT(DISTINCT user_id) as total FROM users WHERE last_seen >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)"
))['total'];

$month_active = mysqli_fetch_assoc(mysqli_query(
    getConn(),
    "SELECT COUNT(DISTINCT user_id) as total FROM users WHERE last_seen >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)"
))['total'];
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php getHead("Dashboard"); ?>
    <style>
        :root {
            --primary: #4361ee;
            --secondary: #3f37c9;
            --success: #4cc9f0;
            --info: #4895ef;
            --warning: #f72585;
            --danger: #e63946;
            --light: #f8f9fa;
            --dark: #212529;
        }

        .dashboard {
            padding: 20px;
            background: #f5f7fb;
            min-height: calc(100vh - 80px);
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: white;
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-left: 4px solid var(--primary);
            transition: transform 0.3s ease;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        .stat-card.prompts {
            border-left-color: #4361ee;
        }

        .stat-card.tools {
            border-left-color: #3f37c9;
        }

        .stat-card.categories {
            border-left-color: #4cc9f0;
        }

        .stat-card.users {
            border-left-color: #4895ef;
        }

        .stat-card.contacts {
            border-left-color: #f72585;
        }

        .stat-card.reports {
            border-left-color: #e63946;
        }

        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 15px;
            font-size: 24px;
        }

        .stat-card.prompts .stat-icon {
            background: #4361ee;
            color: white;
        }

        .stat-card.tools .stat-icon {
            background: #3f37c9;
            color: white;
        }

        .stat-card.categories .stat-icon {
            background: #4cc9f0;
            color: white;
        }

        .stat-card.users .stat-icon {
            background: #4895ef;
            color: white;
        }

        .stat-card.contacts .stat-icon {
            background: #f72585;
            color: white;
        }

        .stat-card.reports .stat-icon {
            background: #e63946;
            color: white;
        }

        .stat-number {
            font-size: 2.5em;
            font-weight: bold;
            margin: 10px 0;
            color: var(--dark);
        }

        .stat-label {
            color: #6c757d;
            font-size: 0.9em;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .quick-actions {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 30px;
        }

        .action-btn {
            background: white;
            border: none;
            padding: 20px;
            border-radius: 12px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            text-decoration: none;
            color: inherit;
            display: block;
        }

        .action-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
            text-decoration: none;
            color: inherit;
        }

        .action-btn i {
            font-size: 24px;
            margin-bottom: 10px;
            display: block;
        }

        .time-filter {
            background: white;
            padding: 20px;
            border-radius: 15px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            margin-bottom: 30px;
        }

        .time-filter h3 {
            margin: 0 0 15px 0;
            color: var(--dark);
        }

        .filter-buttons {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }

        .filter-btn {
            padding: 8px 16px;
            border: 2px solid #e0e0e0;
            background: white;
            border-radius: 25px;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            color: #6c757d;
            font-size: 0.9em;
        }

        .filter-btn:hover,
        .filter-btn.active {
            background: var(--primary);
            color: white;
            border-color: var(--primary);
            text-decoration: none;
        }

        .chart-container {
            background: white;
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            margin-bottom: 30px;
        }

        .chart-title {
            font-size: 1.2em;
            font-weight: 600;
            margin-bottom: 20px;
            color: var(--dark);
        }

        .user-stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .user-stat-card {
            background: white;
            padding: 20px;
            border-radius: 12px;
            text-align: center;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            border-left: 4px solid var(--primary);
        }

        .user-stat-number {
            font-size: 2em;
            font-weight: bold;
            color: var(--primary);
            margin: 10px 0;
        }

        .user-stat-label {
            color: #6c757d;
            font-size: 0.9em;
        }

        .recent-activities {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
            gap: 20px;
        }

        .activity-card {
            background: white;
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .activity-title {
            font-size: 1.2em;
            font-weight: 600;
            margin-bottom: 20px;
            color: var(--dark);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .activity-title a {
            font-size: 0.9em;
            color: var(--primary);
            text-decoration: none;
        }

        .activity-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .activity-item {
            padding: 15px 0;
            border-bottom: 1px solid #eee;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .activity-item:last-child {
            border-bottom: none;
        }

        .activity-info h4 {
            margin: 0 0 5px 0;
            font-size: 0.95em;
        }

        .activity-info p {
            margin: 0;
            color: #6c757d;
            font-size: 0.85em;
        }

        .activity-time {
            color: #6c757d;
            font-size: 0.8em;
        }

        .badge {
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 0.75em;
            font-weight: 600;
        }

        .badge-success {
            background: #d4edda;
            color: #155724;
        }

        .badge-warning {
            background: #fff3cd;
            color: #856404;
        }

        .badge-danger {
            background: #f8d7da;
            color: #721c24;
        }

        @media (max-width: 768px) {
            .stats-grid {
                grid-template-columns: 1fr;
            }

            .recent-activities {
                grid-template-columns: 1fr;
            }

            .quick-actions {
                grid-template-columns: repeat(2, 1fr);
            }

            .filter-buttons {
                justify-content: center;
            }

            .user-stats-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }
    </style>
</head>

<body>
    <?php require_once("includes/header.php"); ?>

    <div class="dashboard">
        <!-- Statistics Grid -->
        <div class="stats-grid">
            <div class="stat-card prompts">
                <div class="stat-icon">
                    <i class='bx bx-message-square-dots'></i>
                </div>
                <div class="stat-number"><?php echo number_format($total_prompts); ?></div>
                <div class="stat-label">Total Prompts</div>
            </div>

            <div class="stat-card tools">
                <div class="stat-icon">
                    <i class='bx bx-cog'></i>
                </div>
                <div class="stat-number"><?php echo number_format($total_tools); ?></div>
                <div class="stat-label">AI Tools</div>
            </div>

            <div class="stat-card categories">
                <div class="stat-icon">
                    <i class='bx bx-category'></i>
                </div>
                <div class="stat-number"><?php echo number_format($total_categories); ?></div>
                <div class="stat-label">Categories</div>
            </div>

            <div class="stat-card users">
                <div class="stat-icon">
                    <i class='bx bx-user'></i>
                </div>
                <div class="stat-number"><?php echo number_format($total_users); ?></div>
                <div class="stat-label">Registered Users</div>
            </div>

            <div class="stat-card contacts">
                <div class="stat-icon">
                    <i class='bx bx-envelope'></i>
                </div>
                <div class="stat-number"><?php echo number_format($total_contacts); ?></div>
                <div class="stat-label">Contact Messages</div>
            </div>

            <div class="stat-card reports">
                <div class="stat-icon">
                    <i class='bx bx-flag'></i>
                </div>
                <div class="stat-number"><?php echo number_format($total_reports); ?></div>
                <div class="stat-label">Reports</div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="quick-actions">
            <a href="notifications.php" class="action-btn">
                <i class='bx bx-bell'></i>
                <div>Notifications</div>
            </a>
            <a href="settings.php" class="action-btn">
                <i class='bx bx-cog'></i>
                <div>Settings</div>
            </a>
            <a href="ads.php" class="action-btn">
                <i class='bx bx-adjust'></i>
                <div>Ads Management</div>
            </a>
            <a href="prompts.php" class="action-btn">
                <i class='bx bx-message-square'></i>
                <div>Manage Prompts</div>
            </a>
            <a href="tools.php" class="action-btn">
                <i class='bx bx-wrench'></i>
                <div>AI Tools</div>
            </a>
            <a href="category.php" class="action-btn">
                <i class='bx bx-category'></i>
                <div>Categories</div>
            </a>
        </div>

        <!-- Time Filter -->
        <div class="time-filter">
            <h3>User Analytics Filter</h3>
            <div class="filter-buttons">
                <a href="?time_filter=last_hour" class="filter-btn <?php echo $time_filter == 'last_hour' ? 'active' : ''; ?>">Last Hour</a>
                <a href="?time_filter=today" class="filter-btn <?php echo $time_filter == 'today' ? 'active' : ''; ?>">Today</a>
                <a href="?time_filter=yesterday" class="filter-btn <?php echo $time_filter == 'yesterday' ? 'active' : ''; ?>">Yesterday</a>
                <a href="?time_filter=week" class="filter-btn <?php echo $time_filter == 'week' ? 'active' : ''; ?>">This Week</a>
                <a href="?time_filter=month" class="filter-btn <?php echo $time_filter == 'month' ? 'active' : ''; ?>">This Month</a>
                <a href="?time_filter=year" class="filter-btn <?php echo $time_filter == 'year' ? 'active' : ''; ?>">This Year</a>
                <a href="?time_filter=all_time" class="filter-btn <?php echo $time_filter == 'all_time' ? 'active' : ''; ?>">All Time</a>
            </div>
        </div>

        <!-- User Stats -->
        <div class="user-stats-grid">
            <div class="user-stat-card">
                <div class="user-stat-number"><?php echo number_format($active_users); ?></div>
                <div class="user-stat-label">Active Users (<?php echo $time_filter; ?>)</div>
            </div>
            <div class="user-stat-card">
                <div class="user-stat-number"><?php echo number_format($new_users); ?></div>
                <div class="user-stat-label">New Users (<?php echo $time_filter; ?>)</div>
            </div>
            <div class="user-stat-card">
                <div class="user-stat-number"><?php echo number_format($today_active); ?></div>
                <div class="user-stat-label">Active Today</div>
            </div>
            <div class="user-stat-card">
                <div class="user-stat-number"><?php echo number_format($yesterday_active); ?></div>
                <div class="user-stat-label">Active Yesterday</div>
            </div>
            <div class="user-stat-card">
                <div class="user-stat-number"><?php echo number_format($week_active); ?></div>
                <div class="user-stat-label">Active This Week</div>
            </div>
            <div class="user-stat-card">
                <div class="user-stat-number"><?php echo number_format($month_active); ?></div>
                <div class="user-stat-label">Active This Month</div>
            </div>
        </div>

        <!-- User Growth Chart -->
        <div class="chart-container">
            <div class="chart-title">User Growth (<?php echo ucfirst(str_replace('_', ' ', $time_filter)); ?>)</div>
            <canvas id="userGrowthChart" height="300"></canvas>
        </div>

        <!-- Recent Activities -->
        <div class="recent-activities">
            <div class="activity-card">
                <div class="activity-title">
                    Popular Prompts
                    <a href="prompts.php">View All</a>
                </div>
                <ul class="activity-list">
                    <?php while ($prompt = mysqli_fetch_assoc($popular_prompts)): ?>
                        <li class="activity-item">
                            <div class="activity-info">
                                <h4><?php echo htmlspecialchars($prompt['title']); ?></h4>
                                <p><?php echo number_format($prompt['views']); ?> views</p>
                            </div>
                            <span class="badge badge-success">Trending</span>
                        </li>
                    <?php endwhile; ?>
                </ul>
            </div>

            <div class="activity-card">
                <div class="activity-title">
                    Recent Contacts
                    <a href="contact.php">View All</a>
                </div>
                <ul class="activity-list">
                    <?php while ($contact = mysqli_fetch_assoc($recent_contacts)): ?>
                        <li class="activity-item">
                            <div class="activity-info">
                                <h4><?php echo htmlspecialchars($contact['topic']); ?></h4>
                                <p><?php echo htmlspecialchars($contact['contact']); ?></p>
                            </div>
                            <span class="activity-time"><?php echo date('M j, g:i A', strtotime($contact['date'])); ?></span>
                        </li>
                    <?php endwhile; ?>
                </ul>
            </div>

            <div class="activity-card">
                <div class="activity-title">
                    Recent Reports
                    <a href="reports.php">View All</a>
                </div>
                <ul class="activity-list">
                    <?php while ($report = mysqli_fetch_assoc($recent_reports)): ?>
                        <li class="activity-item">
                            <div class="activity-info">
                                <h4><?php echo htmlspecialchars($report['type']); ?></h4>
                                <p><?php echo htmlspecialchars(substr($report['message'], 0, 50)); ?>...</p>
                            </div>
                            <span class="badge badge-<?php echo $report['status'] == 1 ? 'success' : 'warning'; ?>">
                                <?php echo $report['status'] == 1 ? 'Resolved' : 'Pending'; ?>
                            </span>
                        </li>
                    <?php endwhile; ?>
                </ul>
            </div>
        </div>
    </div>

    <?php require_once("includes/footer.php"); ?>

    <!-- Chart.js Library -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
        // User Growth Chart
        const userGrowthCtx = document.getElementById('userGrowthChart').getContext('2d');
        const userGrowthChart = new Chart(userGrowthCtx, {
            type: 'line',
            data: {
                labels: <?php echo json_encode(array_column($user_growth_data, 'label')); ?>,
                datasets: [{
                    label: 'New Users',
                    data: <?php echo json_encode(array_column($user_growth_data, 'count')); ?>,
                    borderColor: '#4361ee',
                    backgroundColor: 'rgba(67, 97, 238, 0.1)',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        grid: {
                            drawBorder: false
                        },
                        title: {
                            display: true,
                            text: 'Number of Users'
                        }
                    },
                    x: {
                        grid: {
                            display: false
                        },
                        title: {
                            display: true,
                            text: '<?php echo ucfirst(str_replace('_', ' ', $time_filter)); ?>'
                        }
                    }
                }
            }
        });

        // Auto refresh dashboard every 60 seconds
        setInterval(() => {
            location.reload();
        }, 60000);
    </script>
</body>

</html>