<?php require_once("app.php");

if (isset($_GET['page'])) {
    $page = mysqli_real_escape_string(getConn(), $_GET['page']);
    if ($page <= 0) {
        $page = 1;
    }
} else {
    $page = 1;
}

$per_page = 30;
$start = ($page - 1) * $per_page;

$search_query = "";
$order_url = "";
$order_type = "unsolved";
$order_by = "ORDER BY id DESC";
$by_item_status = " `read` = 0";  // Fixed: using backticks for reserved word

if (isset($_GET['order'])) {
    $order_type = mysqli_real_escape_string(getConn(), $_GET['order']);
    $order_url = "order=" . $order_type . "&";

    // ------ Sort --------
    if ($order_type === "latest") {
        $order_by = "ORDER BY id DESC";
        $by_item_status = "`read` >= 0";
    } else if ($order_type === "old") {
        $order_by = "ORDER BY id ASC";
        $by_item_status = "`read` >= 0";
    } else if ($order_type === "unsolved") {
        $order_by = "ORDER BY id DESC";
        $by_item_status = "`read` = 0";
    } else if ($order_type === "solved") {
        $order_by = "ORDER BY id DESC";
        $by_item_status = "`read` = 1";
    } else if ($order_type === "unsolved_old") {
        $order_by = "ORDER BY id ASC";
        $by_item_status = "`read` = 0";
    } else if ($order_type === "solved_old") {
        $order_by = "ORDER BY id ASC";
        $by_item_status = "`read` = 1";
    }
    // ------ Filter by Topic --------
    else {
        $by_item_status .= " && topic = '$order_type' ";
    }
}

// Get distinct topics for the dropdown
$topics_result = mysqli_query(getConn(), "SELECT DISTINCT topic FROM contact WHERE topic IS NOT NULL AND topic != '' ORDER BY topic");
$topics = [];
while ($topic_row = mysqli_fetch_assoc($topics_result)) {
    $topics[] = $topic_row['topic'];
}

$totalItems = mysqli_num_rows(mysqli_query(getConn(), "SELECT * FROM contact WHERE $by_item_status $order_by"));

if (isset($_GET['q'])) {
    $search = mysqli_real_escape_string(getConn(), $_GET['q']);
    $search_query = "q=$search&";

    if (is_numeric($search)) {
        $qItem = "SELECT * FROM contact  
        WHERE id = $search || user_id = $search || contact = $search  && $by_item_status $order_by LIMIT 10";
    } else {
        $qItem = "SELECT * FROM contact  
        WHERE lower(contact) LIKE lower('%$search%') || lower(topic) LIKE lower('%$search%') && $by_item_status $order_by LIMIT $start,$per_page";
    }

    $items = mysqli_query(getConn(), $qItem);

    $totalItems = mysqli_num_rows(mysqli_query(getConn(), "SELECT * FROM contact  
    WHERE lower(contact) LIKE lower('%$search%') || lower(topic) LIKE lower('%$search%') && $by_item_status $order_by"));
} else {
    $search = "Search Here...";
    $items = mysqli_query(getConn(), "SELECT * FROM contact WHERE $by_item_status $order_by LIMIT $start,$per_page");
}

// =====Pagination====
$totalPage = ceil($totalItems / $per_page);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <?php getHead("Contacts"); ?>
</head>

<body>
    <?php require_once("includes/header.php"); ?>

    <div class="table_header">
        <div>
            <form action="" method="get" id="search_f">
                <input type="hidden" name="order" value="<?php echo $order_type ?>">
                <input type="search" name="q" id="search" placeholder="<?php echo $search ?>">
                <input type="submit" value="Search">
            </form>
        </div>

        <div class="filters" style="display: flex; gap: 10px; align-items: center; flex-wrap: wrap;">
            <div class="filter">
                <select name="order" id="order" onchange="changeOrder(this.value)">
                    <option value="latest" <?php echo $order_type == "latest" ? "selected" : ""; ?>>All Latest Contacts</option>
                    <option value="old" <?php echo $order_type == "old" ? "selected" : ""; ?>>All Old Contacts</option>
                    <option value="unsolved" <?php echo $order_type == "unsolved" ? "selected" : ""; ?>>Unsolved</option>
                    <option value="solved" <?php echo $order_type == "solved" ? "selected" : ""; ?>>Solved</option>
                    <option value="unsolved_old" <?php echo $order_type == "unsolved_old" ? "selected" : ""; ?>>Unsolved (OLD)</option>
                    <option value="solved_old" <?php echo $order_type == "solved_old" ? "selected" : ""; ?>>Solved (OLD)</option>
                </select>
            </div>

            <div class="filter">
                <select name="order" id="order" onchange="changeOrder(this.value)">
                    <?php
                    // Automatically populate topics from database
                    foreach ($topics as $topic) {
                        $selected = $order_type == $topic ? "selected" : "";
                        echo "<option value=\"$topic\" $selected>$topic</option>";
                    }
                    ?>
                </select>
            </div>

        </div>

    </div>

    <script>
        function changeOrder(val) {
            let orderElement = document.createElement("a");
            orderElement.setAttribute("href", "?order=" + val);
            orderElement.click();
        }
    </script>

    <table class="caption-top">
        <caption>Contacts</caption>
        <tr>
            <th>ID</th>
            <th>Message</th>
            <th>Contact</th>
            <th>Topic</th>
            <th>Date</th>
            <th>Action</th>
        </tr>

        <?php
        while ($r = mysqli_fetch_assoc($items)) {
            $id = $r['id'];
            $user_id = $r['user_id'];
            $topic = $r['topic'];
            $message = $r['message'];
            $contact = $r['contact'];
            $status = $r['read'];
            $date = date("d-M-Y", strtotime($r['date']));
            $time = date("H:i:s", strtotime($r['date']));

            $display_date = $date . "<br>" . $time;
            $full_message = htmlspecialchars($message, ENT_QUOTES, 'UTF-8');

            // Format message for display in table
            if (strlen($message) > 50) {
                $display_message = substr($message, 0, 30) . "<br>" . substr($message, 30, 60) . "<br>" . substr($message, 90, 40);
            } else {
                $display_message = $message;
            }
        ?>
            <tr>
                <td><?php echo $id ?></td>
                <td class="fill"><?php echo $display_message ?></td>
                <td><?php echo $contact ?></td>
                <td><?php echo $topic ?></td>
                <td><?php echo $display_date ?></td>
                <td class="actions">
                    <input type="checkbox" <?php echo $status == "1" ? "checked" : ""; ?> onclick="changeStatus('<?php echo $id ?>',this,'contact')" title="Mark as read">
                    <?php if (!empty($user_id)): ?>
                        <a href="users_profile.php?id=<?php echo $user_id ?>&edit=false" class="orange"><i class="bx bx-user"></i></a>
                    <?php endif; ?>

                    <a class="green view-message-btn"
                        data-contact="<?= htmlspecialchars($contact, ENT_QUOTES, 'UTF-8') ?>"
                        data-topic="<?= htmlspecialchars($topic, ENT_QUOTES, 'UTF-8') ?>"
                        data-date="<?= htmlspecialchars($date, ENT_QUOTES, 'UTF-8') ?>"
                        data-time="<?= htmlspecialchars($time, ENT_QUOTES, 'UTF-8') ?>"
                        data-message="<?= $full_message ?>">
                        <i class="bx bx-show-alt"></i>
                    </a>

                    <a onclick="deleteItem('<?php echo $id ?>','delete_contact')" class="red"><i class="bx bx-trash"></i></a>
                </td>
            </tr>
        <?php
        }
        ?>
    </table>

    <!-- ===============Pagination=============== -->
    <?php generatePagination($page, $totalPage, "?" . $order_url . $search_query); ?>

    <?php require_once("includes/footer.php"); ?>

    <!--=============================== Modal =======================-->
    <div class="modal fade" id="messageModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Message Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <p><strong>From:</strong> <span id="modalContact"></span></p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Topic:</strong> <span id="modalTopic"></span></p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <p><strong>Date:</strong> <span id="modalDate"></span></p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Time:</strong> <span id="modalTime"></span></p>
                        </div>
                    </div>
                    <div class="mb-3">
                        <p><strong>Message:</strong></p>
                        <div class="p-3 bg-light rounded" id="modalMessage" style="white-space: pre-wrap;"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Handle all view message buttons
            document.querySelectorAll('.view-message-btn').forEach(btn => {
                btn.addEventListener('click', function() {
                    // Get data attributes
                    const contact = this.getAttribute('data-contact');
                    const topic = this.getAttribute('data-topic');
                    const date = this.getAttribute('data-date');
                    const time = this.getAttribute('data-time');
                    const message = this.getAttribute('data-message');

                    // Set modal content
                    document.getElementById('modalContact').textContent = contact;
                    document.getElementById('modalTopic').textContent = topic;
                    document.getElementById('modalDate').textContent = date;
                    document.getElementById('modalTime').textContent = time;
                    document.getElementById('modalMessage').textContent = message;

                    // Show modal
                    const modal = new bootstrap.Modal(document.getElementById('messageModal'));
                    modal.show();
                });
            });
        });
    </script>
</body>

</html>