<?php
require_once('app.php');

$date = date("Y-m-d H:i:s");

if (isset($_POST['add'])) {
    $title = mysqli_real_escape_string(getConn(), $_POST['title']);
    $type = mysqli_real_escape_string(getConn(), $_POST['type']);
    $value = mysqli_real_escape_string(getConn(), $_POST['value']);
    $status = mysqli_real_escape_string(getConn(), $_POST['status']);
    $icon_url = mysqli_real_escape_string(getConn(), $_POST['icon_url']);

    $path = "../uploads/Chips/";
    if (!file_exists($path)) {
        mkdir($path, 0777, true);
    }

    if (!empty($_FILES['icon']['name'])) {
        $source_file = $_FILES['icon']['tmp_name'];
        $file_name = "CHIP_" . date("YmdHis") . "_" . random(8) . getExtension($_FILES['icon']['name']);

        if (move_uploaded_file($source_file, ($path . $file_name))) {
            $icon_url = "Chips/" . $file_name;
        }
    }

    $q = mysqli_query(getConn(), "INSERT INTO `chips`(`title`, `icon`, `type`, `value`, `status`) VALUES ('$title','$icon_url','$type','$value','$status')");

    if ($q) {
        echo "<script>history.go(-2);</script>";
    } else {
        echo "<script>showAlert('Sorry','Something went wrong..')</script>";
    }
}

if (isset($_POST['update'])) {
    $update_id = mysqli_real_escape_string(getConn(), $_POST['id']);
    $title = mysqli_real_escape_string(getConn(), $_POST['title']);
    $type = mysqli_real_escape_string(getConn(), $_POST['type']);
    $value = mysqli_real_escape_string(getConn(), $_POST['value']);
    $status = mysqli_real_escape_string(getConn(), $_POST['status']);
    $icon_url = mysqli_real_escape_string(getConn(), $_POST['icon_url']);

    $path = "../uploads/Chips/";
    if (!file_exists($path)) {
        mkdir($path, 0777, true);
    }

    if (!empty($_FILES['icon']['name'])) {
        $source_file = $_FILES['icon']['tmp_name'];
        $file_name = "CHIP_" . date("YmdHis") . "_" . random(8) . getExtension($_FILES['icon']['name']);

        if (move_uploaded_file($source_file, ($path . $file_name))) {
            $icon_url = "Chips/" . $file_name;
        }
    }

    $q = mysqli_query(getConn(), "UPDATE `chips` SET `title`='$title',`icon`='$icon_url',`type`='$type',`value`='$value',`status`='$status' WHERE id = $update_id LIMIT 1");

    if ($q) {
        echo "<script>history.go(-2);</script>";
    } else {
        echo "<script>showAlert('Sorry','Something went wrong..')</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <?php getHead("Chips Action"); ?>
</head>


<body>
    <?php include_once('includes/header.php');

    if (isset($_GET['id'])) {
        $id = $_GET['id'];
        $chip = mysqli_fetch_assoc(mysqli_query(getConn(), "SELECT * FROM chips WHERE id = $id LIMIT 1"));
    ?>

        <form action="" method="POST" enctype="multipart/form-data">
            <input type="hidden" name="id" value="<?php echo $id; ?>">

            <fieldset>
                <legend>Chip Information</legend>
                
                <div class="input">
                    <label for="title">Title:</label>
                    <input type="text" id="title" name="title" value="<?php echo $chip['title']; ?>" required>
                </div>
                
                <div class="input">
                    <label for="type">Type:</label>
                    <input type="text" id="type" name="type" value="<?php echo $chip['type']; ?>" required>
                </div>
                
                <div class="input">
                    <label for="value">Value:</label>
                    <input type="text" id="value" name="value" value="<?php echo $chip['value']; ?>" required>
                </div>
            </fieldset>

            <fieldset>
                <legend>Icon</legend>
                <div class="input img">
                    <label for="icon">
                        <img src="<?php echo getImage($chip['icon']); ?>" id="icon_img">
                    </label>
                    <div class="inputs">
                        <input type="file" name="icon" id="icon" onchange="previewIcon();" accept="image/*" />
                        <input type="text" id="icon_url" name="icon_url" value="<?php echo $chip['icon']; ?>">
                    </div>
                </div>
            </fieldset>

            <div class="input">
                <label for="status">Status:</label>
                <select name="status" id="status" required>
                    <option value="1" <?php echo $chip['status'] == "1" ? "selected" : ""; ?>>Active</option>
                    <option value="0" <?php echo $chip['status'] == "0" ? "selected" : ""; ?>>Inactive</option>
                </select>
            </div>

            <input type="submit" value="Update Chip" name="update" id="submit_button">
        </form>

    <?php } else { ?>

        <form action="" method="POST" enctype="multipart/form-data">

            <fieldset>
                <legend>Chip Information</legend>
                
                <div class="input">
                    <label for="title">Title:</label>
                    <input type="text" id="title" name="title" value="" required>
                </div>
                
                <div class="input">
                    <label for="type">Type:</label>
                    <input type="text" id="type" name="type" value="" required>
                </div>
                
                <div class="input">
                    <label for="value">Value:</label>
                    <input type="text" id="value" name="value" value="" required>
                </div>
            </fieldset>

            <fieldset>
                <legend>Icon</legend>
                <div class="input img">
                    <label for="icon">
                        <img src="<?php echo getImage(''); ?>" id="icon_img">
                    </label>
                    <div class="inputs">
                        <input type="file" name="icon" id="icon" onchange="previewIcon();" accept="image/*" />
                        <input type="text" id="icon_url" name="icon_url" value="">
                    </div>
                </div>
            </fieldset>

            <div class="input">
                <label for="status">Status:</label>
                <select name="status" id="status" required>
                    <option value="1" selected>Active</option>
                    <option value="0">Inactive</option>
                </select>
            </div>

            <input type="submit" value="Add Chip" name="add" id="submit_button">
        </form>

    <?php } ?>

    <script>
        function previewIcon() {
            var oFReader = new FileReader();
            oFReader.readAsDataURL(document.getElementById("icon").files[0]);
            oFReader.onload = function(oFREvent) {
                document.getElementById("icon_img").src = oFREvent.target.result;
            };
        }
    </script>

    <?php include_once('includes/footer.php'); ?>
</body>
</html>