<?php 
require_once("app.php");

if (isset($_GET['page'])) {
    $page = mysqli_real_escape_string(getConn(), $_GET['page']);
    if ($page <= 0) {
        $page = 1;
    }
} else {
    $page = 1;
}

$per_page = 30;
$start = ($page - 1) * $per_page;

$search_query = "";
$order_url = "";
$order_type = "all";
$order_by = "ORDER BY id DESC";
$by_item_status = "status = 1";

if (isset($_GET['order'])) {
    $order_type = mysqli_real_escape_string(getConn(), $_GET['order']);
    $order_url = "order=" . $order_type . "&";

    // Status filters
    if ($order_type === "active") {
        $by_item_status = "status = 1";
        $order_by = "ORDER BY id DESC";
    } else if ($order_type === "inactive") {
        $by_item_status = "status = 0";
        $order_by = "ORDER BY id DESC";
    } else if ($order_type === "all") {
        $by_item_status = "status >= 0";
        $order_by = "ORDER BY id DESC";
    } else if ($order_type === "latest") {
        $order_by = "ORDER BY id DESC";
        $by_item_status = "status >= 0";
    } else if ($order_type === "old") {
        $order_by = "ORDER BY id ASC";
        $by_item_status = "status >= 0";
    }
    // Type filters
    else {
        $by_item_status .= " && type = '$order_type'";
    }
}

$totalItems = mysqli_num_rows(mysqli_query(getConn(), "SELECT * FROM chips WHERE $by_item_status $order_by"));

if (isset($_GET['q'])) {
    $search = mysqli_real_escape_string(getConn(), $_GET['q']);
    $search_query = "q=$search&";

    $qItem;
    if (is_numeric($search)) {
        $qItem = "SELECT * FROM chips  
        WHERE id = $search && $by_item_status $order_by LIMIT 10";
    } else {
        $qItem = "SELECT * FROM chips  
        WHERE lower(title) LIKE lower('%$search%') || lower(type) LIKE lower('%$search%') || lower(value) LIKE lower('%$search%') && $by_item_status $order_by LIMIT $start,$per_page";
    }

    $items = mysqli_query(getConn(), $qItem);
    $totalItems = mysqli_num_rows(mysqli_query(getConn(), "SELECT * FROM chips  
    WHERE lower(title) LIKE lower('%$search%') || lower(type) LIKE lower('%$search%') || lower(value) LIKE lower('%$search%') && $by_item_status $order_by"));
} else {
    $search = "Search Here...";
    $items = mysqli_query(getConn(), "SELECT * FROM chips WHERE $by_item_status $order_by LIMIT $start,$per_page");
}

// =====Pagination====
$totalPage = ceil($totalItems / $per_page);

// Get distinct types for filter
$types = mysqli_query(getConn(), "SELECT DISTINCT type FROM chips WHERE type != ''");
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <?php getHead("Chips"); ?>
</head>

<body>
    <?php require_once("includes/header.php"); ?>

    <div class="table_header">
        <div>
            <form action="" method="get" id="search_f">
                <input type="hidden" name="order" value="<?php echo $order_type ?>">
                <input type="search" name="q" id="search" placeholder="<?php echo $search ?>">
                <input type="submit" value="Search">
            </form>
        </div>

        <a href="chips_action.php">Add New Chip</a>

        <div class="filters">
            <div class="filter">
                <select name="order" id="order" onchange="changeOrder(this.value)">
                    <optgroup label="Status">
                        <option value="all" <?php echo $order_type == "all" ? "selected" : ""; ?>>All Chips</option>
                        <option value="active" <?php echo $order_type == "active" ? "selected" : ""; ?>>Active</option>
                        <option value="inactive" <?php echo $order_type == "inactive" ? "selected" : ""; ?>>Inactive</option>
                    </optgroup>

                    <optgroup label="Sort">
                        <option value="latest" <?php echo $order_type == "latest" ? "selected" : ""; ?>>Latest First</option>
                        <option value="old" <?php echo $order_type == "old" ? "selected" : ""; ?>>Oldest First</option>
                    </optgroup>

                    <optgroup label="By Type">
                        <?php
                        while ($type = mysqli_fetch_assoc($types)) {
                            if (!empty($type['type'])) {
                                ?>
                                <option value="<?php echo $type['type']; ?>" <?php echo $order_type == $type['type'] ? "selected" : ""; ?>>
                                    <?php echo ucfirst($type['type']); ?>
                                </option>
                                <?php
                            }
                        }
                        ?>
                    </optgroup>
                </select>
            </div>
        </div>
    </div>

    <script>
        function changeOrder(val) {
            let orderElement = document.createElement("a");
            orderElement.setAttribute("href", "?order=" + val);
            orderElement.click();
        }
    </script>

    <table class="caption-top">
        <caption>Chips</caption>
        <tr>
            <th>ID</th>
            <th>Icon</th>
            <th>Title</th>
            <th>Type</th>
            <th>Value</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>

        <?php
        while ($r = mysqli_fetch_assoc($items)) {
            $id = $r['id'];
            $title = $r['title'];
            $icon = $r['icon'];
            $type = $r['type'];
            $value = $r['value'];
            $status = $r['status'];
        ?>
            <tr>
                <td><?php echo $id ?></td>
                <td>
                    <?php if (!empty($icon)): ?>
                        <img src="<?php echo getImage($icon); ?>" alt="Icon" style="width: 30px; height: 30px; object-fit: contain;">
                    <?php else: ?>
                        <span>No Icon</span>
                    <?php endif; ?>
                </td>
                <td><?php echo htmlspecialchars($title) ?></td>
                <td><?php echo htmlspecialchars($type) ?></td>
                <td><?php echo htmlspecialchars($value) ?></td>
                <td><?php echo $status == 1 ? "Active" : "Inactive" ?></td>
                <td class="actions">
                    <input type="checkbox" <?php echo $status == "1" ? "checked" : ""; ?> onclick="changeStatus('<?php echo $id ?>',this,'chips')" title="Active/Inactive">
                    <a href="chips_action.php?id=<?php echo $id ?>" class="dodgerblue"><i class="bx bx-edit"></i></a>
                    <?php if ($status == "0") { ?>
                        <a onclick="deleteItem('<?php echo $id ?>','delete_chips')" class="red" title="Delete Permanently"><i class="bx bx-trash"></i></a>
                    <?php } ?>
                </td>
            </tr>
        <?php
        }
        ?>
    </table>

    <!-- ===============Pagination=============== -->
    <?php generatePagination($page, $totalPage, "?" . $order_url . $search_query); ?>

    <?php require_once("includes/footer.php"); ?>
</body>
</html>