<?php
require_once("app.php");

// Get distinct tags for dropdown
$tag_options = [];
$tag_query = mysqli_query(getConn(), "SELECT DISTINCT tag FROM category WHERE tag IS NOT NULL AND tag != ''");
while ($tag_row = mysqli_fetch_assoc($tag_query)) {
    $tag_options[] = $tag_row['tag'];
}

if (isset($_POST['add'])) {

    $title =  mysqli_real_escape_string(getConn(), $_POST['title']);
    $tag =  mysqli_real_escape_string(getConn(), $_POST['tag']);
    $cover_url =  mysqli_real_escape_string(getConn(), $_POST['cover_url']);
    $bg =  mysqli_real_escape_string(getConn(), $_POST['bg']);

    // Agar new tag hai to use tag field me set karo
    if (!empty($_POST['new_tag'])) {
        $tag = mysqli_real_escape_string(getConn(), $_POST['new_tag']);
    }

    if (!empty($_FILES['cover']['name'])) {

        $path = "../uploads/CATEGORY/";
        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }
        $source_file = $_FILES['cover']['tmp_name'];
        $file_name = "CAT_" . date("YmdHis") . "_" . random(8) . getExtension($_FILES['cover']['name']);
        $destination = $path . $file_name;

        if (move_uploaded_file($source_file, $destination)) {

            $cover_url = "CATEGORY/" . $file_name;
        }
    }


    $q = "INSERT INTO `category`(`tag`, `title`, `cover`, `bg`, `status`, `date`) VALUES ('$tag','$title','$cover_url','$bg',1,NOW())";

    if (mysqli_query(getConn(), $q)) {

        echo "<script>history.go(-2);</script>";
    } else {
        echo "<script>showAlert('Sorry','Something went wrong..')</script>";
    }
}



if (isset($_POST['update'])) {

    $category_id =  mysqli_real_escape_string(getConn(), $_POST['id']);
    $title =  mysqli_real_escape_string(getConn(), $_POST['title']);
    $tag =  mysqli_real_escape_string(getConn(), $_POST['tag']);
    $bg =  mysqli_real_escape_string(getConn(), $_POST['bg']);

    // Agar new tag hai to use tag field me set karo
    if (!empty($_POST['new_tag'])) {
        $tag = mysqli_real_escape_string(getConn(), $_POST['new_tag']);
    }

    $cover_url =  mysqli_real_escape_string(getConn(), $_POST['cover_url']);

    if (!empty($_FILES['cover']['name'])) {

        $path = "../uploads/CATEGORY/";
        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }
        $source_file = $_FILES['cover']['tmp_name'];
        $file_name = "CAT_" . date("YmdHis") . "_" . random(8) . getExtension($_FILES['cover']['name']);
        $destination = $path . $file_name;

        if (move_uploaded_file($source_file, $destination)) {

            $cover_url = "CATEGORY/" . $file_name;
        }
    }


    $q = "UPDATE `category` SET `tag`='$tag',`title`='$title',`cover`='$cover_url',`bg`='$bg' WHERE id = $category_id LIMIT 1";

    if (mysqli_query(getConn(), $q)) {

        echo "<script>history.go(-2);</script>";
    } else {
        echo "<script>showAlert('Sorry','Something went wrong..')</script>";
    }
}




?>


<!DOCTYPE html>
<html lang="en">

<head>
    <?php getHead("Category Action"); ?>
</head>

<body>
    <?php require_once('includes/header.php');

    if (isset($_GET['id'])) {

        $category_id = mysqli_real_escape_string(getConn(), $_GET['id']);

        $category_query = mysqli_query(getConn(), "SELECT * FROM `category` WHERE id = $category_id");

        if (mysqli_num_rows($category_query) == 1) {

            $category_query = mysqli_fetch_assoc($category_query);
        } else {
            echo "<script>history.go(-1);</script>";
        }
    ?>


        <form action="" method="POST" enctype="multipart/form-data">

            <input type="hidden" name="id" value="<?php echo $category_id; ?>">


            <fieldset>
                <legend>Cover Image</legend>
                <div class="input img">
                    <label for="cover">
                        <img src="<?php echo getImage($category_query['cover']); ?>" alt="<?php echo $category_query['title']; ?>" id="cover_img">
                    </label>

                    <div class="inputs">
                        <input type="file" name="cover" id="cover" onchange="PreviewImage();" accept="image/*" />
                        <input type="text" id="cover_url" name="cover_url" placeholder="Cover Url Here.." required value="<?php echo $category_query['cover']; ?>">
                    </div>

                </div>
            </fieldset>


            <fieldset>

                <legend>Information</legend>


                <div class="input">
                    <label for="title">Title : </label>
                    <input type="text" id="title" name="title" placeholder="Title Here.." value="<?php echo $category_query['title']; ?>">
                </div>

                <div class="input">
                    <label for="tag">Tag : </label>
                    <select id="tag" name="tag">
                        <option value="">Select Tag</option>
                        <?php foreach ($tag_options as $option): ?>
                            <option value="<?php echo $option; ?>" <?php echo ($category_query['tag'] == $option) ? 'selected' : ''; ?>>
                                <?php echo $option; ?>
                            </option>
                        <?php endforeach; ?>
                        <option value="custom">Custom Tag</option>
                    </select>
                    <input type="text" id="new_tag" name="new_tag" placeholder="Enter New Tag" style="margin-top: 5px; display: none;" value="">
                </div>

                <div class="input">
                    <label for="bg">Background : </label>
                    <input type="text" id="bg" name="bg" placeholder="Background Here.." value="<?php echo $category_query['bg']; ?>">
                </div>

            </fieldset>



            <input type="submit" value="Update" name="update" id="submit_button">


        </form>



    <?php } else { ?>



        <form action="" method="POST" enctype="multipart/form-data">


            <fieldset>
                <legend>Cover Image</legend>
                <div class="input img">
                    <label for="cover">
                        <img src="img/upload.png" id="cover_img">
                    </label>
                    <div class="inputs">
                        <input type="file" name="cover" id="cover" onchange="PreviewImage();" accept="image/jpg , image/jpeg, image/png" />
                        <input type="text" id="cover_url" name="cover_url" placeholder="Cover Url Here..">
                    </div>
                </div>

            </fieldset>

            <fieldset>

                <legend>Information</legend>

                <div class="input">
                    <label for="title">Title : </label>
                    <input type="text" id="title" name="title" placeholder="Title here.." required>
                </div>

                <div class="input">
                    <label for="tag">Tag : </label>
                    <select id="tag" name="tag">
                        <option value="">Select Tag</option>
                        <?php foreach ($tag_options as $option): ?>
                            <option value="<?php echo $option; ?>"><?php echo $option; ?></option>
                        <?php endforeach; ?>
                        <option value="custom">Custom Tag</option>
                    </select>
                    <input type="text" id="new_tag" name="new_tag" placeholder="Enter New Tag" style="margin-top: 5px; display: none;">
                </div>

                <div class="input">
                    <label for="bg">Background : </label>
                    <input type="text" id="bg" name="bg" placeholder="Background here..">
                </div>

            </fieldset>

            <input type="submit" value="Add" name="add" id="submit_button">


        </form>


    <?php }
    ?>


    <?php require_once("includes/footer.php"); ?>

    <script>
        document.getElementById('tag').addEventListener('change', function() {
            var newTagInput = document.getElementById('new_tag');
            if (this.value === 'custom') {
                newTagInput.style.display = 'block';
                newTagInput.required = true;
            } else {
                newTagInput.style.display = 'none';
                newTagInput.required = false;
                newTagInput.value = '';
            }
        });

        // Form submit se pehle check karo
        document.querySelector('form').addEventListener('submit', function(e) {
            var tagSelect = document.getElementById('tag');
            var newTagInput = document.getElementById('new_tag');

            if (tagSelect.value === 'custom' && newTagInput.value.trim() === '') {
                e.preventDefault();
                alert('Please enter a custom tag');
                newTagInput.focus();
            }
        });
    </script>
</body>

</html>