<?php
require_once("app.php");

if (isset($_GET['page'])) {
    $page = mysqli_real_escape_string(getConn(), $_GET['page']);
    if ($page <= 0) {
        $page = 1;
    }
} else {
    $page = 1;
}

$per_page = 30;

$start = ($page - 1) * $per_page;

$search_query = "";

$order_url = "";
$order_type = "latest";
$order_by = "ORDER BY id DESC";

$by_item_status = "status >= 0";


if (isset($_GET['order'])) {

    $order_type = mysqli_real_escape_string(getConn(), $_GET['order']);

    $order_url = "order=" . $order_type . "&";

    if ($order_type === "disable") {
        $by_item_status = "status = 0";
    } else if ($order_type === "enable") {
        $by_item_status = "status = 1";
    } else if ($order_type == "all") {

        $by_item_status = "status >= 0";
    } else if ($order_type === "old") {

        $order_by = "ORDER BY id ASC";
    } else {

        $order_by = "ORDER BY id DESC";
    }
}


$totalItems = mysqli_num_rows(mysqli_query(getConn(), "SELECT `id` FROM category WHERE $by_item_status $order_by"));

if (isset($_GET['q'])) {

    $search = mysqli_real_escape_string(getConn(), $_GET['q']);

    $search_query = "q=$search&";

    $quser;
    if (is_numeric($search)) {
        $quser = "SELECT * FROM  category 
        WHERE id = $search && $by_item_status $order_by LIMIT 10";
    } else {
        $quser = "SELECT * FROM  category 
        WHERE LOWER(title) LIKE LOWER('%$search%')  && $by_item_status $order_by LIMIT $start,$per_page";
    }

    $items = mysqli_query(getConn(), $quser);

    $totalItems = mysqli_num_rows(mysqli_query(getConn(), "SELECT * FROM  category 
    WHERE title LIKE '%$search%' && $by_item_status $order_by"));
} else {

    $search = "Search Here...";
    $items = mysqli_query(getConn(), "SELECT * FROM  category WHERE $by_item_status $order_by limit $start,$per_page");
}




// =====Pagination====
$totalPage = ceil($totalItems / $per_page);


?>


<!DOCTYPE html>
<html lang="en">

<head>
    <?php getHead("Category"); ?>
</head>

<body>
    <?php require_once("includes/header.php"); ?>

    <div class="table_header">
        <div>
            <form action="" method="get" id="search_f">
                <input type="hidden" name="order" value="<?php echo $order_type ?>">

                <input type="search" name="q" id="search" placeholder="<?php echo $search ?>">
                <input type="submit" value="Search">
            </form>
        </div>

        <a href="category_action">Add More</a>

        <div class="dropdowns">

            <select name="order" id="order" onchange="changeOrder(this.value)">
                <option value="all" <?php echo $order_type == "all" ? "selected" : ""; ?>>All</option>
                <option value="disable" <?php echo $order_type == "disable" ? "selected" : ""; ?>>Disabled</option>
                <option value="enable" <?php echo $order_type == "enable" ? "selected" : ""; ?>>Enabled</option>
                <option value="latest" <?php echo $order_type == "latest" ? "selected" : ""; ?>>Latest</option>
                <option value="old" <?php echo $order_type == "old" ? "selected" : ""; ?>>Old</option>
            </select>

        </div>

        <script>
            function changeTopic(val) {
                let orderElement = document.createElement("a");
                orderElement.setAttribute("href", "?order=" + val);
                orderElement.click();
            }

            function changeOrder(val) {
                let orderElement = document.createElement("a");
                orderElement.setAttribute("href", "?order=" + val);
                orderElement.click();
            }
        </script>
    </div>



    <table class="caption-top">

        <caption>Category</caption>

        <tr>
            <th>ID</th>
            <th>Cover</th>
            <th>Title</th>
            <th>Tag</th>
            <th>BG Color</th>
            <th>Action</th>
        </tr>

        <?php

        while ($r = mysqli_fetch_assoc($items)) {

            $id = $r['id'];

        ?>
            <tr>
                <td><?php echo $id ?></td>
                <td><img src="<?php echo getImage($r['cover']); ?>" id="cover" loading="lazy"></td>
                <td class="fill"><?php echo $r['title']; ?></td>
                <td><?php echo $r['tag']; ?></td>
                <td><?php echo $r['bg']; ?></td>
                <td class="actions">
                    <input type="checkbox" <?php echo $r['status'] == "1" ? "checked" : ""; ?> onclick="changeStatus('<?php echo $id ?>',this,'category')">
                    <a href="category_action?id=<?php echo $id ?>" class="dodgerblue"><i class="bx bx-edit"></i></a>
                    <a onclick="deleteItem('<?php echo $id ?>','delete_category')" class="red"><i class="bx bx-trash"></i></a>
                </td>
            </tr>

        <?php
        }

        ?>

    </table>


    <!-- ===============Pagination=============== -->

    <?php generatePagination($page, $totalPage, "?" . $order_url . $search_query); ?>


    <!-- ===========================EXTRA SCRIPT============= -->

    <?php require_once("includes/footer.php"); ?>
</body>

</html>