<?php

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once("../includes/db.php");

// ======================= Verification ================
$current_file = pathinfo($_SERVER['PHP_SELF'], PATHINFO_FILENAME);



    if (!(isset($_SESSION['user']) && isset($_SESSION['password']))) {
        header("Location:index.php");
        exit();
    }

    $admin_user = $_SESSION['user'];
    $admin_password = $_SESSION['password'];

    $admin_fire = mysqli_query(getConn(), "SELECT * FROM `admin` WHERE `user`='$admin_user' && `password`='$admin_password'");

    if (mysqli_num_rows($admin_fire) == 1) {

        $ADMIN = mysqli_fetch_assoc($admin_fire);
    } else {
        header("Location:index.php");
        exit();
    }


$ADMIN_ACCESS = $ADMIN['access'];
$ADMIN_ACCESS_MODE = $ADMIN['access_mode'];
$CHAT_USER = $ADMIN['chat_user'];

$SHOW_ACTION = false;

if ($ADMIN_ACCESS_MODE != "VIEW") {
    $SHOW_ACTION = true;
}

$HAVE_ACCESS = true;

function checkPerm($type)
{
    global $ADMIN, $ADMIN_ACCESS, $HAVE_ACCESS, $SHOW_ACTION;

    if (str_contains($ADMIN_ACCESS, $type) || $ADMIN['role'] == "SUPER" || $type == "Dashboard" || $type == "Access") {
        $HAVE_ACCESS = true;
        $SHOW_ACTION = true;
    }
}

checkAccess($current_file);


$accesses_keys = array(
    // 🧮 Dashboard & Reports
    "Dashboard",

    // 🛍️ Product Management
    "Category",
    "Prompts",
    "Tools",
    "Chips",

    // 📢 Marketing & Notifications
    "Ads",
    "Pop",
    "Notifications",

    // 🧑‍💼 Users & Access
    "Users",
    "Access",

    // ⚙️ System & Settings
    "Settings",
    "Report",
    "Contact"
);

function checkAccess($current_file)
{
    // 🧮 Dashboard & Reports
    if (str_contains($current_file, "dashboard")) {
        checkPerm("Dashboard");
    } else if (str_contains($current_file, "users") || str_contains($current_file, "users_profile")) {
        checkPerm("Users");
    }

    // 📢 Marketing & Notifications
    else if (str_contains($current_file, "category")) {
        checkPerm("Category");
    } else if (str_contains($current_file, "prompts")) {
        checkPerm("Prompts");
    } else if (str_contains($current_file, "tools")) {
        checkPerm("Tools");
    } else if (str_contains($current_file, "chips")) {
        checkPerm("Chips");
    }

    // 🧑‍💼 Users & Access
    else if (str_contains($current_file, "ads")) {
        checkPerm("Ads");
    } else if (str_contains($current_file, "pop")) {
        checkPerm("Pop");
    } else if (str_contains($current_file, "notifications")) {
        checkPerm("Notifications");
    } else if (str_contains($current_file, "access")) {
        checkPerm("Access");
    }

    // ⚙️ System & Settings
    else if (str_contains($current_file, "settings")) {
        checkPerm("Settings");
    } else if (str_contains($current_file, "contact")) {
        checkPerm("Contact");
    } else if (str_contains($current_file, "report")) {
        checkPerm("Report");
    }
}


function requireAccess()
{
    global $HAVE_ACCESS;
    if (!isset($HAVE_ACCESS) || !$HAVE_ACCESS) {
        exit("Access Denied.");
    }
}


require_once("includes/function.php");
