<?php
require_once('app.php');

// Handle form submission
if (isset($_POST['update_ads'])) {
    // Admob fields
    $admob_id = mysqli_real_escape_string(getConn(), $_POST['admob_id']);
    $admob_banner = mysqli_real_escape_string(getConn(), $_POST['admob_banner']);
    $admob_interstitial = mysqli_real_escape_string(getConn(), $_POST['admob_interstitial']);
    $admob_native = mysqli_real_escape_string(getConn(), $_POST['admob_native']);
    $admob_rew = mysqli_real_escape_string(getConn(), $_POST['admob_rew']);
    $admob_open = mysqli_real_escape_string(getConn(), $_POST['admob_open']);

    // ADX fields
    $adx_id = mysqli_real_escape_string(getConn(), $_POST['adx_id']);
    $adx_banner = mysqli_real_escape_string(getConn(), $_POST['adx_banner']);
    $adx_interstitial = mysqli_real_escape_string(getConn(), $_POST['adx_interstitial']);
    $adx_native = mysqli_real_escape_string(getConn(), $_POST['adx_native']);
    $adx_rew = mysqli_real_escape_string(getConn(), $_POST['adx_rew']);
    $adx_open = mysqli_real_escape_string(getConn(), $_POST['adx_open']);

    // Lovin fields
    $lovin_id = mysqli_real_escape_string(getConn(), $_POST['lovin_id']);
    $lovin_banner = mysqli_real_escape_string(getConn(), $_POST['lovin_banner']);
    $lovin_interstitial = mysqli_real_escape_string(getConn(), $_POST['lovin_interstitial']);
    $lovin_native = mysqli_real_escape_string(getConn(), $_POST['lovin_native']);
    $lovin_rew = mysqli_real_escape_string(getConn(), $_POST['lovin_rew']);
    $lovin_open = mysqli_real_escape_string(getConn(), $_POST['lovin_open']);

    // Meta fields
    $meta_banner = mysqli_real_escape_string(getConn(), $_POST['meta_banner']);
    $meta_interstitial = mysqli_real_escape_string(getConn(), $_POST['meta_interstitial']);
    $meta_native = mysqli_real_escape_string(getConn(), $_POST['meta_native']);
    $meta_rew = mysqli_real_escape_string(getConn(), $_POST['meta_rew']);
    $meta_open = mysqli_real_escape_string(getConn(), $_POST['meta_open']);

    // Ad types
    $type_banner = mysqli_real_escape_string(getConn(), $_POST['type_banner']);
    $type_interstitial = mysqli_real_escape_string(getConn(), $_POST['type_interstitial']);
    $type_native = mysqli_real_escape_string(getConn(), $_POST['type_native']);
    $type_rew = mysqli_real_escape_string(getConn(), $_POST['type_rew']);
    $type_open = mysqli_real_escape_string(getConn(), $_POST['type_open']);

    // Status fields
    $status_total_ad = isset($_POST['status_total_ad']) ? 1 : 0;
    $status_banner_ad = isset($_POST['status_banner_ad']) ? 1 : 0;
    $status_interstitial_ad = isset($_POST['status_interstitial_ad']) ? 1 : 0;
    $status_native_ad = isset($_POST['status_native_ad']) ? 1 : 0;
    $status_rew_ad = isset($_POST['status_rew_ad']) ? 1 : 0;
    $status_open_ad = isset($_POST['status_open_ad']) ? 1 : 0;

    // Intervals
    $native_interval = mysqli_real_escape_string(getConn(), $_POST['native_interval']);
    $interstitial_interval = mysqli_real_escape_string(getConn(), $_POST['interstitial_interval']);

    // Ad types for actions
    $ad_type_copy = mysqli_real_escape_string(getConn(), $_POST['ad_type_copy']);
    $ad_type_share = mysqli_real_escape_string(getConn(), $_POST['ad_type_share']);
    $ad_type_info = mysqli_real_escape_string(getConn(), $_POST['ad_type_info']);
    $ad_type_save = mysqli_real_escape_string(getConn(), $_POST['ad_type_save']);

    $update_query = "UPDATE ads SET 
        admob_id = '$admob_id',
        admob_banner = '$admob_banner',
        admob_interstitial = '$admob_interstitial',
        admob_native = '$admob_native',
        admob_rew = '$admob_rew',
        admob_open = '$admob_open',
        adx_id = '$adx_id',
        adx_banner = '$adx_banner',
        adx_interstitial = '$adx_interstitial',
        adx_native = '$adx_native',
        adx_rew = '$adx_rew',
        adx_open = '$adx_open',
        lovin_id = '$lovin_id',
        lovin_banner = '$lovin_banner',
        lovin_interstitial = '$lovin_interstitial',
        lovin_native = '$lovin_native',
        lovin_rew = '$lovin_rew',
        lovin_open = '$lovin_open',
        meta_banner = '$meta_banner',
        meta_interstitial = '$meta_interstitial',
        meta_native = '$meta_native',
        meta_rew = '$meta_rew',
        meta_open = '$meta_open',
        type_banner = '$type_banner',
        type_interstitial = '$type_interstitial',
        type_native = '$type_native',
        type_rew = '$type_rew',
        type_open = '$type_open',
        status_total_ad = '$status_total_ad',
        status_banner_ad = '$status_banner_ad',
        status_interstitial_ad = '$status_interstitial_ad',
        status_native_ad = '$status_native_ad',
        status_rew_ad = '$status_rew_ad',
        status_open_ad = '$status_open_ad',
        native_interval = '$native_interval',
        interstitial_interval = '$interstitial_interval',
        ad_type_copy = '$ad_type_copy',
        ad_type_share = '$ad_type_share',
        ad_type_info = '$ad_type_info',
        ad_type_save = '$ad_type_save'
    WHERE id = 1";

    if (mysqli_query(getConn(), $update_query)) {
        echo "<script>history.go(-1);</script>";
    } else {
        echo "<script>showAlert('Error','Failed to update ads configuration!')</script>";
    }
}

$ADS = mysqli_fetch_assoc(mysqli_query(getConn(), "SELECT * FROM ads WHERE id = 1 LIMIT 1"));
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <?php getHead("Ads Management"); ?>

</head>

<style>
    .tabs-container {
        background: white;
        border-radius: 10px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        margin-bottom: 20px;
        overflow: hidden;
    }

    .tabs-header {
        display: flex;
        background: #f8f9fa;
        border-bottom: 1px solid #dee2e6;
    }

    .tab-btn {
        padding: 15px 30px;
        background: none;
        border: none;
        cursor: pointer;
        font-size: 16px;
        font-weight: 500;
        color: #6c757d;
        border-bottom: 3px solid transparent;
        transition: all 0.3s ease;
    }

    .tab-btn.active {
        color: #007bff;
        border-bottom-color: #007bff;
        background: white;
    }

    .tab-btn:hover {
        color: #0056b3;
        background: #e9ecef;
    }

    .tab-content {
        display: none;
        padding: 30px;
    }

    .tab-content.active {
        display: block;
    }

    .adnetworks_section {
        margin-bottom: 30px;
    }

    .adnetworks_section h3 {
        color: #333;
        border-bottom: 2px solid #007bff;
        padding-bottom: 10px;
        margin-bottom: 20px;
    }

    .form-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
        margin-bottom: 20px;
    }

    .form-group {
        margin-bottom: 15px;
    }

    .form-group label {
        display: block;
        margin-bottom: 5px;
        font-weight: bold;
        color: #555;
    }

    .form-group input,
    .form-group select {
        width: 100%;
        padding: 8px 12px;
        border: 1px solid #ddd;
        border-radius: 5px;
        font-size: 14px;
    }

    .form-group input:focus,
    .form-group select:focus {
        outline: none;
        border-color: #007bff;
        box-shadow: 0 0 5px rgba(0, 123, 255, 0.3);
    }

    .checkbox-group {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .checkbox-group input[type="checkbox"] {
        width: auto;
    }

    .status-section {
        background: #f8f9fa;
        padding: 15px;
        border-radius: 5px;
        margin-bottom: 20px;
    }

    .submit-btn {
        background: #007bff;
        color: white;
        padding: 12px 30px;
        border: none;
        border-radius: 5px;
        cursor: pointer;
        font-size: 16px;
        font-weight: bold;
    }

    .submit-btn:hover {
        background: #0056b3;
    }

    .ad-type-options {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 15px;
    }

    .info-text {
        font-size: 12px;
        color: #666;
        margin-top: 5px;
    }

    .form-actions {
        text-align: center;
        margin-top: 30px;
        padding-top: 20px;
        border-top: 1px solid #dee2e6;
    }
</style>

<body>
    <?php include_once('includes/header.php'); ?>


    <form action="" method="POST">
        <div class="tabs-container">
            <div class="tabs-header">
                <button type="button" class="tab-btn active" data-tab="tab-admob">Admob</button>
                <button type="button" class="tab-btn" data-tab="tab-adx">ADX</button>
                <button type="button" class="tab-btn" data-tab="tab-meta">Meta</button>
                <button type="button" class="tab-btn" data-tab="tab-lovin">App Lovin</button>
                <button type="button" class="tab-btn" data-tab="tab-settings">Settings</button>
            </div>

            <!-- Admob Tab -->
            <div class="tab-content active" id="tab-admob">
                <div class="adnetworks_section">
                    <h3>Admob Settings</h3>
                    <div class="form-grid">
                        <div class="form-group">
                            <label>Admob App ID</label>
                            <input type="text" name="admob_id" value="<?php echo $ADS['admob_id']; ?>" placeholder="ca-app-pub-xxxxxxxxxxxxxxxx~xxxxxxxxxx">
                        </div>
                        <div class="form-group">
                            <label>Banner Ad Unit</label>
                            <input type="text" name="admob_banner" value="<?php echo $ADS['admob_banner']; ?>" placeholder="ca-app-pub-xxxxxxxxxxxxxxxx/xxxxxxxxxx">
                        </div>
                        <div class="form-group">
                            <label>Interstitial Ad Unit</label>
                            <input type="text" name="admob_interstitial" value="<?php echo $ADS['admob_interstitial']; ?>" placeholder="ca-app-pub-xxxxxxxxxxxxxxxx/xxxxxxxxxx">
                        </div>
                        <div class="form-group">
                            <label>Native Ad Unit</label>
                            <input type="text" name="admob_native" value="<?php echo $ADS['admob_native']; ?>" placeholder="ca-app-pub-xxxxxxxxxxxxxxxx/xxxxxxxxxx">
                        </div>
                        <div class="form-group">
                            <label>Rewarded Ad Unit</label>
                            <input type="text" name="admob_rew" value="<?php echo $ADS['admob_rew']; ?>" placeholder="ca-app-pub-xxxxxxxxxxxxxxxx/xxxxxxxxxx">
                        </div>
                        <div class="form-group">
                            <label>App Open Ad Unit</label>
                            <input type="text" name="admob_open" value="<?php echo $ADS['admob_open']; ?>" placeholder="ca-app-pub-xxxxxxxxxxxxxxxx/xxxxxxxxxx">
                        </div>
                    </div>
                </div>
            </div>

            <!-- ADX Tab -->
            <div class="tab-content" id="tab-adx">
                <div class="adnetworks_section">
                    <h3>ADX Settings</h3>
                    <div class="form-grid">
                        <div class="form-group">
                            <label>ADX App ID</label>
                            <input type="text" name="adx_id" value="<?php echo $ADS['adx_id']; ?>" placeholder="ca-app-pub-xxxxxxxxxxxxxxxx~xxxxxxxxxx">
                        </div>
                        <div class="form-group">
                            <label>ADX Banner</label>
                            <input type="text" name="adx_banner" value="<?php echo $ADS['adx_banner']; ?>" placeholder="/21775744923/example/fixed-size-banner">
                        </div>
                        <div class="form-group">
                            <label>ADX Interstitial</label>
                            <input type="text" name="adx_interstitial" value="<?php echo $ADS['adx_interstitial']; ?>" placeholder="/21775744923/example/interstitial">
                        </div>
                        <div class="form-group">
                            <label>ADX Native</label>
                            <input type="text" name="adx_native" value="<?php echo $ADS['adx_native']; ?>" placeholder="/21775744923/example/native">
                        </div>
                        <div class="form-group">
                            <label>ADX Rewarded</label>
                            <input type="text" name="adx_rew" value="<?php echo $ADS['adx_rew']; ?>" placeholder="/21775744923/example/rewarded">
                        </div>
                        <div class="form-group">
                            <label>ADX App Open</label>
                            <input type="text" name="adx_open" value="<?php echo $ADS['adx_open']; ?>" placeholder="/21775744923/example/app-open">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Meta Tab -->
            <div class="tab-content" id="tab-meta">
                <div class="adnetworks_section">
                    <h3>Meta (Facebook) Settings</h3>
                    <div class="form-grid">
                        <div class="form-group">
                            <label>Meta Banner</label>
                            <input type="text" name="meta_banner" value="<?php echo $ADS['meta_banner']; ?>" placeholder="IMG_16_9_APP_INSTALL#YOUR_PLACEMENT_ID">
                        </div>
                        <div class="form-group">
                            <label>Meta Interstitial</label>
                            <input type="text" name="meta_interstitial" value="<?php echo $ADS['meta_interstitial']; ?>" placeholder="VID_HD_16_9_46S_APP_INSTALL#YOUR_PLACEMENT_ID">
                        </div>
                        <div class="form-group">
                            <label>Meta Native</label>
                            <input type="text" name="meta_native" value="<?php echo $ADS['meta_native']; ?>" placeholder="IMG_16_9_APP_INSTALL#YOUR_PLACEMENT_ID">
                        </div>
                        <div class="form-group">
                            <label>Meta Rewarded</label>
                            <input type="text" name="meta_rew" value="<?php echo $ADS['meta_rew']; ?>" placeholder="VID_HD_16_9_46S_APP_INSTALL#YOUR_PLACEMENT_ID">
                        </div>
                        <div class="form-group">
                            <label>Meta App Open</label>
                            <input type="text" name="meta_open" value="<?php echo $ADS['meta_open']; ?>" placeholder="VID_HD_16_9_46S_APP_INSTALL#YOUR_PLACEMENT_ID">
                        </div>
                    </div>
                </div>
            </div>

            <!-- App Lovin Tab -->
            <div class="tab-content" id="tab-lovin">
                <div class="adnetworks_section">
                    <h3>Lovin Settings</h3>
                    <div class="form-grid">
                        <div class="form-group">
                            <label>Lovin SDK Key</label>
                            <input type="text" name="lovin_id" value="<?php echo $ADS['lovin_id']; ?>" placeholder="Your Lovin SDK Key">
                        </div>
                        <div class="form-group">
                            <label>Lovin Banner</label>
                            <input type="text" name="lovin_banner" value="<?php echo $ADS['lovin_banner']; ?>" placeholder="Lovin Banner ID">
                        </div>
                        <div class="form-group">
                            <label>Lovin Interstitial</label>
                            <input type="text" name="lovin_interstitial" value="<?php echo $ADS['lovin_interstitial']; ?>" placeholder="Lovin Interstitial ID">
                        </div>
                        <div class="form-group">
                            <label>Lovin Native</label>
                            <input type="text" name="lovin_native" value="<?php echo $ADS['lovin_native']; ?>" placeholder="Lovin Native ID">
                        </div>
                        <div class="form-group">
                            <label>Lovin Rewarded</label>
                            <input type="text" name="lovin_rew" value="<?php echo $ADS['lovin_rew']; ?>" placeholder="Lovin Rewarded ID">
                        </div>
                        <div class="form-group">
                            <label>Lovin App Open</label>
                            <input type="text" name="lovin_open" value="<?php echo $ADS['lovin_open']; ?>" placeholder="Lovin App Open ID">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Settings Tab -->
            <div class="tab-content" id="tab-settings">
                <!-- Ad Type Selection -->
                <div class="adnetworks_section">
                    <h3>Ad Network Selection</h3>
                    <div class="form-grid">
                        <div class="form-group">
                            <label>Banner Ad Type</label>
                            <select name="type_banner">
                                <option value="ADMOB" <?php echo $ADS['type_banner'] == 'ADMOB' ? 'selected' : ''; ?>>Admob</option>
                                <option value="ADX" <?php echo $ADS['type_banner'] == 'ADX' ? 'selected' : ''; ?>>ADX</option>
                                <option value="META" <?php echo $ADS['type_banner'] == 'META' ? 'selected' : ''; ?>>Meta</option>
                                <option value="LOVIN" <?php echo $ADS['type_banner'] == 'LOVIN' ? 'selected' : ''; ?>>Lovin</option>
                                <option value="NONE" <?php echo $ADS['type_banner'] == 'NONE' ? 'selected' : ''; ?>>None</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Interstitial Ad Type</label>
                            <select name="type_interstitial">
                                <option value="ADMOB" <?php echo $ADS['type_interstitial'] == 'ADMOB' ? 'selected' : ''; ?>>Admob</option>
                                <option value="ADX" <?php echo $ADS['type_interstitial'] == 'ADX' ? 'selected' : ''; ?>>ADX</option>
                                <option value="META" <?php echo $ADS['type_interstitial'] == 'META' ? 'selected' : ''; ?>>Meta</option>
                                <option value="LOVIN" <?php echo $ADS['type_interstitial'] == 'LOVIN' ? 'selected' : ''; ?>>Lovin</option>
                                <option value="NONE" <?php echo $ADS['type_interstitial'] == 'NONE' ? 'selected' : ''; ?>>None</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Native Ad Type</label>
                            <select name="type_native">
                                <option value="ADMOB" <?php echo $ADS['type_native'] == 'ADMOB' ? 'selected' : ''; ?>>Admob</option>
                                <option value="ADX" <?php echo $ADS['type_native'] == 'ADX' ? 'selected' : ''; ?>>ADX</option>
                                <option value="META" <?php echo $ADS['type_native'] == 'META' ? 'selected' : ''; ?>>Meta</option>
                                <option value="LOVIN" <?php echo $ADS['type_native'] == 'LOVIN' ? 'selected' : ''; ?>>Lovin</option>
                                <option value="NONE" <?php echo $ADS['type_native'] == 'NONE' ? 'selected' : ''; ?>>None</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Rewarded Ad Type</label>
                            <select name="type_rew">
                                <option value="ADMOB" <?php echo $ADS['type_rew'] == 'ADMOB' ? 'selected' : ''; ?>>Admob</option>
                                <option value="ADX" <?php echo $ADS['type_rew'] == 'ADX' ? 'selected' : ''; ?>>ADX</option>
                                <option value="META" <?php echo $ADS['type_rew'] == 'META' ? 'selected' : ''; ?>>Meta</option>
                                <option value="LOVIN" <?php echo $ADS['type_rew'] == 'LOVIN' ? 'selected' : ''; ?>>Lovin</option>
                                <option value="NONE" <?php echo $ADS['type_rew'] == 'NONE' ? 'selected' : ''; ?>>None</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>App Open Ad Type</label>
                            <select name="type_open">
                                <option value="ADMOB" <?php echo $ADS['type_open'] == 'ADMOB' ? 'selected' : ''; ?>>Admob</option>
                                <option value="ADX" <?php echo $ADS['type_open'] == 'ADX' ? 'selected' : ''; ?>>ADX</option>
                                <option value="META" <?php echo $ADS['type_open'] == 'META' ? 'selected' : ''; ?>>Meta</option>
                                <option value="LOVIN" <?php echo $ADS['type_open'] == 'LOVIN' ? 'selected' : ''; ?>>Lovin</option>
                                <option value="NONE" <?php echo $ADS['type_open'] == 'NONE' ? 'selected' : ''; ?>>None</option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Ad Status Settings -->
                <div class="adnetworks_section">
                    <h3>Ad Status & Intervals</h3>
                    <div class="status-section">
                        <div class="form-grid">
                            <div class="checkbox-group">
                                <input type="checkbox" name="status_total_ad" id="status_total_ad" value="1" <?php echo $ADS['status_total_ad'] ? 'checked' : ''; ?>>
                                <label for="status_total_ad">Enable All Ads</label>
                            </div>
                            <div class="checkbox-group">
                                <input type="checkbox" name="status_banner_ad" id="status_banner_ad" value="1" <?php echo $ADS['status_banner_ad'] ? 'checked' : ''; ?>>
                                <label for="status_banner_ad">Banner Ads</label>
                            </div>
                            <div class="checkbox-group">
                                <input type="checkbox" name="status_interstitial_ad" id="status_interstitial_ad" value="1" <?php echo $ADS['status_interstitial_ad'] ? 'checked' : ''; ?>>
                                <label for="status_interstitial_ad">Interstitial Ads</label>
                            </div>
                            <div class="checkbox-group">
                                <input type="checkbox" name="status_native_ad" id="status_native_ad" value="1" <?php echo $ADS['status_native_ad'] ? 'checked' : ''; ?>>
                                <label for="status_native_ad">Native Ads</label>
                            </div>
                            <div class="checkbox-group">
                                <input type="checkbox" name="status_rew_ad" id="status_rew_ad" value="1" <?php echo $ADS['status_rew_ad'] ? 'checked' : ''; ?>>
                                <label for="status_rew_ad">Rewarded Ads</label>
                            </div>
                            <div class="checkbox-group">
                                <input type="checkbox" name="status_open_ad" id="status_open_ad" value="1" <?php echo $ADS['status_open_ad'] ? 'checked' : ''; ?>>
                                <label for="status_open_ad">App Open Ads</label>
                            </div>
                        </div>
                    </div>

                    <div class="form-grid">
                        <div class="form-group">
                            <label>Native Ad Interval</label>
                            <input type="number" name="native_interval" value="<?php echo $ADS['native_interval']; ?>" min="1" max="100">
                            <div class="info-text">Number of actions between native ads</div>
                        </div>
                        <div class="form-group">
                            <label>Interstitial Ad Interval</label>
                            <input type="number" name="interstitial_interval" value="<?php echo $ADS['interstitial_interval']; ?>" min="1" max="100">
                            <div class="info-text">Number of actions between interstitial ads</div>
                        </div>
                    </div>
                </div>

                <!-- Ad Type for Actions -->
                <div class="adnetworks_section">
                    <h3>Ad Type for User Actions</h3>
                    <div class="ad-type-options">
                        <div class="form-group">
                            <label>Copy Action</label>
                            <select name="ad_type_copy">
                                <option value="NONE" <?php echo $ADS['ad_type_copy'] == 'NONE' ? 'selected' : ''; ?>>No Ad</option>
                                <option value="INT" <?php echo $ADS['ad_type_copy'] == 'INT' ? 'selected' : ''; ?>>Interstitial</option>
                                <option value="REW" <?php echo $ADS['ad_type_copy'] == 'REW' ? 'selected' : ''; ?>>Rewarded</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Share Action</label>
                            <select name="ad_type_share">
                                <option value="NONE" <?php echo $ADS['ad_type_share'] == 'NONE' ? 'selected' : ''; ?>>No Ad</option>
                                <option value="INT" <?php echo $ADS['ad_type_share'] == 'INT' ? 'selected' : ''; ?>>Interstitial</option>
                                <option value="REW" <?php echo $ADS['ad_type_share'] == 'REW' ? 'selected' : ''; ?>>Rewarded</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Info Action</label>
                            <select name="ad_type_info">
                                <option value="NONE" <?php echo $ADS['ad_type_info'] == 'NONE' ? 'selected' : ''; ?>>No Ad</option>
                                <option value="INT" <?php echo $ADS['ad_type_info'] == 'INT' ? 'selected' : ''; ?>>Interstitial</option>
                                <option value="REW" <?php echo $ADS['ad_type_info'] == 'REW' ? 'selected' : ''; ?>>Rewarded</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Save Action</label>
                            <select name="ad_type_save">
                                <option value="NONE" <?php echo $ADS['ad_type_save'] == 'NONE' ? 'selected' : ''; ?>>No Ad</option>
                                <option value="INT" <?php echo $ADS['ad_type_save'] == 'INT' ? 'selected' : ''; ?>>Interstitial</option>
                                <option value="REW" <?php echo $ADS['ad_type_save'] == 'REW' ? 'selected' : ''; ?>>Rewarded</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-actions">
                <button type="submit" name="update_ads" class="submit-btn">Update Ads Configuration</button>
            </div>
            <br>
        </div>


    </form>



    <script>
        // Tab functionality
        document.addEventListener('DOMContentLoaded', function() {
            const tabBtns = document.querySelectorAll('.tab-btn');
            const tabContents = document.querySelectorAll('.tab-content');

            tabBtns.forEach(btn => {
                btn.addEventListener('click', function() {
                    const tabId = this.getAttribute('data-tab');

                    // Remove active class from all buttons and contents
                    tabBtns.forEach(b => b.classList.remove('active'));
                    tabContents.forEach(c => c.classList.remove('active'));

                    // Add active class to current button and content
                    this.classList.add('active');
                    document.getElementById(tabId).classList.add('active');
                });
            });
        });
    </script>

    <?php include_once('includes/footer.php'); ?>
</body>

</html>