<?php

// ============================================ CATEGORY ======================================

function getCategory()
{
    $res['res_status'] = false;
    $res['res_message'] = "Something went wrong..!";
    $res['res'] = array();

    $per_page = 20;
    $res['per_page'] = $per_page;

    if (isset($_POST['last'])) {

        $last = intval($_POST['last']);

        $tags = mysqli_query(getConn(), "SELECT DISTINCT tag FROM category WHERE status = 1 ORDER BY RAND() LIMIT $last, $per_page");

        while ($tag = mysqli_fetch_assoc($tags)) {

            $tag_name = $tag['tag'];

            $categories = mysqli_query(getConn(), "SELECT * FROM category WHERE tag = '$tag_name' AND status = 1 ORDER BY RAND()");

            $category_data['item'] = array();
            while ($category = mysqli_fetch_assoc($categories)) {
                array_push($category_data['item'], $category);
            }

            $tag['items'] = $category_data;

            array_push($res['res'], $tag);
        }

        $res['res_status'] = true;
        if (mysqli_num_rows($tags) > 0) {
            $res['res_message'] = "Success!";
        } else {
            $res['res_message'] = "Oops..! category not found";
        }
    }

    echo json_encode($res, JSON_PRETTY_PRINT);
}



// ============================================ Home Screen ======================================

function getPrompts()
{
    $res['res_status'] = false;
    $res['res_message'] = "Something went wrong..!";
    $res['res'] = array();

    $per_page = 20;
    $res['per_page'] = $per_page;

    if (isset($_POST['last'])) {

        $last = intval($_POST['last']);

        $items = mysqli_query(getConn(), "SELECT * FROM prompts WHERE status = 1 ORDER BY id DESC LIMIT $last, $per_page");

        while ($item = mysqli_fetch_assoc($items)) {

            $item['date'] = timeAgo($item['date']);
            $item['views'] = counter($item['views']);

            array_push($res['res'], $item);
        }

        $res['res_status'] = true;
        if (mysqli_num_rows($items) > 0) {
            $res['res_message'] = "Success!";
        } else {
            $res['res_message'] = "Oops..! no any prompts found";
        }
    }

    echo json_encode($res, JSON_PRETTY_PRINT);
}



// ============================================ Saved ======================================

function getSaved()
{
    $res['res_status'] = false;
    $res['res_message'] = "No saved item found..!";
    $res['res'] = array();

    $per_page = 20;
    $res['per_page'] = $per_page;

    if (isset($_POST['last'],$_POST['saved_id'])) {

        $last = intval($_POST['last']);
        $SAVED_ID = mysqli_real_escape_string(getConn(), $_POST['saved_id']);
        
        $ids = array_map('intval', explode(',', $SAVED_ID));
        $SAVED_ID = implode(',', $ids);
        
        if (empty($SAVED_ID)) {
            $res['res_status'] = true;
            echo json_encode($res, JSON_PRETTY_PRINT);
            return;
        }


        $items = mysqli_query(getConn(), "SELECT * FROM prompts WHERE id IN($SAVED_ID) AND status = 1 ORDER BY id DESC LIMIT $last, $per_page");

        while ($item = mysqli_fetch_assoc($items)) {

            $item['date'] = timeAgo($item['date']);
            $item['views'] = counter($item['views']);

            array_push($res['res'], $item);
        }

        $res['res_status'] = true;
        if (mysqli_num_rows($items) > 0) {
            $res['res_message'] = "Success!";
        } else {
            $res['res_message'] = "Oops..! no any saved prompts found";
        }
    }

    echo json_encode($res, JSON_PRETTY_PRINT);
}


// ============================================ Search ======================================



function getSearch()
{
    $res['res_status'] = false;
    $res['res_message'] = "Something went wrong..!";
    $res['res'] = array();

    $per_page = 20;
    $res['per_page'] = $per_page;

    if (isset($_POST['last'])) {

        $last = intval($_POST['last']);

        if (isset($_POST['category_id'])) {
            $category_id = intval($_POST['category_id']);
        } else {
            $category_id = "";
        }

        if (isset($_POST['query'])) {
            $query = strtolower(mysqli_real_escape_string(getConn(), $_POST['query']));
        } else {
            $query = "";
        }

        if (isset($_POST['filter'])) {
            $filter = strtolower(mysqli_real_escape_string(getConn(), $_POST['filter']));
        } else {
            $filter = "";
        }
        
        if (isset($_POST['tag'])) {
            $tag = strtolower(mysqli_real_escape_string(getConn(), $_POST['tag']));
        } else {
            $tag = "";
        }



        // ========================== Create System ==========================

        $sql = "SELECT * FROM prompts WHERE status = 1";

        // Add category filter if provided
        if ($category_id > 0) {
            $sql .= " AND category_id = $category_id";
        }

        // Add search query if provided
        if (!empty($query)) {

            $sql .= " OR ( LOWER(title) LIKE '%$query%' OR LOWER(prompt) LIKE '%$query%' OR LOWER(tag) LIKE '%$query%' )";
        }


        // Add search query if provided
        if (!empty($tag)) {

            $sql .= " OR ( LOWER(keywords) LIKE '%$tag%' OR LOWER(tag) LIKE '%$tag%' )";
        }


        // Add ordering based on filter
        switch ($filter) {
            case "popular":
                $sql .= " ORDER BY views DESC";
                break;
            case "old":
                $sql .= " ORDER BY id ASC";
                break;
            case "trending":
                $sql .= " ORDER BY views DESC, date DESC";
                break;
            case "random":
                $sql .= " ORDER BY RAND()";
                break;
            case "latest":
                $sql .= " ORDER BY id DESC";
                break;
        }
        
         // Add ordering based on filter
        

        $sql .= " LIMIT $last, $per_page";

        $items = mysqli_query(getConn(), $sql);

        while ($item = mysqli_fetch_assoc($items)) {

            $item['date'] = timeAgo($item['date']);
            $item['views'] = counter($item['views']);

            array_push($res['res'], $item);
        }

        $res['res_status'] = true;
        if (mysqli_num_rows($items) > 0) {
            $res['res_message'] = "Success!";
        } else {
            $res['res_message'] = "Oops..! no any prompts found";
        }
    }

    echo json_encode($res, JSON_PRETTY_PRINT);
}




// ============================================ Saved ======================================

function getNotify()
{
    $res['res_status'] = false;
    $res['res_message'] = "Oops..! no any notifications found";
    $res['res'] = array();

    $per_page = 20;
    $res['per_page'] = $per_page;

    if (isset($_POST['last'])) {

        $last = intval($_POST['last']);

        $items = mysqli_query(getConn(), "SELECT * FROM notifications WHERE status = 1 ORDER BY date DESC LIMIT $last, $per_page");

        while ($item = mysqli_fetch_assoc($items)) {

            $item['date'] = timeAgo($item['date']);
            
            array_push($res['res'], $item);
        }

        $res['res_status'] = true;
        if (mysqli_num_rows($items) > 0) {
            $res['res_message'] = "Success!";
        }
    }

    echo json_encode($res, JSON_PRETTY_PRINT);
}
































